/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class SaveAndSyncHandlerImpl
extends SaveAndSyncHandler
implements Disposable {
    private static final Logger LOG = Logger.getInstance(SaveAndSyncHandler.class);
    private final Runnable myIdleListener;
    private final PropertyChangeListener myGeneralSettingsListener;
    private final GeneralSettings mySettings;
    private final ProgressManager myProgressManager;
    private final SingleAlarm myRefreshDelayAlarm = new SingleAlarm(this::doScheduledRefresh, 300, this);
    private final AtomicInteger myBlockSaveOnFrameDeactivationCount = new AtomicInteger();
    private final AtomicInteger myBlockSyncOnFrameActivationCount = new AtomicInteger();
    private volatile long myRefreshSessionId;

    public SaveAndSyncHandlerImpl(@NotNull GeneralSettings generalSettings, @NotNull ProgressManager progressManager, @NotNull FrameStateManager frameStateManager, @NotNull FileDocumentManager fileDocumentManager) {
        this.mySettings = generalSettings;
        this.myProgressManager = progressManager;
        this.myIdleListener = () -> {
            if (this.mySettings.isAutoSaveIfInactive() && this.canSyncOrSave()) {
                TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> ((FileDocumentManagerImpl)fileDocumentManager).saveAllDocuments(false));
            }
        };
        IdeEventQueue.getInstance().addIdleListener(this.myIdleListener, this.mySettings.getInactiveTimeout() * 1000);
        this.myGeneralSettingsListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent e) {
                if ("inactiveTimeout".equals(e.getPropertyName())) {
                    IdeEventQueue eventQueue = IdeEventQueue.getInstance();
                    eventQueue.removeIdleListener(SaveAndSyncHandlerImpl.this.myIdleListener);
                    Integer timeout = (Integer)e.getNewValue();
                    eventQueue.addIdleListener(SaveAndSyncHandlerImpl.this.myIdleListener, timeout * 1000);
                }
            }
        };
        this.mySettings.addPropertyChangeListener(this.myGeneralSettingsListener);
        frameStateManager.addListener(new FrameStateListener(){

            public void onFrameDeactivated() {
                LOG.debug("save(): enter");
                TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> {
                    if (SaveAndSyncHandlerImpl.this.canSyncOrSave()) {
                        SaveAndSyncHandlerImpl.this.saveProjectsAndDocuments();
                    }
                    LOG.debug("save(): exit");
                });
            }

            public void onFrameActivated() {
                if (!ApplicationManager.getApplication().isDisposed() && SaveAndSyncHandlerImpl.this.mySettings.isSyncOnFrameActivation()) {
                    SaveAndSyncHandlerImpl.this.scheduleRefresh();
                }
            }
        });
    }

    public void dispose() {
        RefreshQueue.getInstance().cancelSession(this.myRefreshSessionId);
        this.mySettings.removePropertyChangeListener(this.myGeneralSettingsListener);
        IdeEventQueue.getInstance().removeIdleListener(this.myIdleListener);
    }

    private boolean canSyncOrSave() {
        return !LaterInvocator.isInModalContext() && !this.myProgressManager.hasModalProgressIndicator();
    }

    public void saveProjectsAndDocuments() {
        if (!ApplicationManager.getApplication().isDisposed() && this.mySettings.isSaveOnFrameDeactivation() && this.myBlockSaveOnFrameDeactivationCount.get() == 0) {
            SaveAndSyncHandlerImpl.doSaveDocumentsAndProjectsAndApp();
        }
    }

    public static void doSaveDocumentsAndProjectsAndApp() {
        LOG.debug("saving documents");
        FileDocumentManager.getInstance().saveAllDocuments();
        for (Project project2 : ProjectManagerEx.getInstanceEx().getOpenProjects()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("saving project: " + project2);
            }
            project2.save();
        }
        LOG.debug("saving application settings");
        ApplicationManager.getApplication().saveSettings();
    }

    public void scheduleRefresh() {
        this.myRefreshDelayAlarm.cancelAndRequest();
    }

    private void doScheduledRefresh() {
        if (this.canSyncOrSave()) {
            this.refreshOpenFiles();
        }
        this.maybeRefresh(ModalityState.NON_MODAL);
    }

    public void maybeRefresh(@NotNull ModalityState modalityState) {
        if (this.myBlockSyncOnFrameActivationCount.get() == 0 && this.mySettings.isSyncOnFrameActivation()) {
            RefreshQueue queue = RefreshQueue.getInstance();
            queue.cancelSession(this.myRefreshSessionId);
            RefreshSession session2 = queue.createSession(true, true, null, modalityState);
            session2.addAllFiles(ManagingFS.getInstance().getLocalRoots());
            this.myRefreshSessionId = session2.getId();
            session2.launch();
            LOG.debug("vfs refreshed");
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("vfs refresh rejected, blocked: " + (this.myBlockSyncOnFrameActivationCount.get() != 0) + ", isSyncOnFrameActivation: " + this.mySettings.isSyncOnFrameActivation());
        }
    }

    public void refreshOpenFiles() {
        ArrayList files = ContainerUtil.newArrayList();
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            for (VirtualFile file2 : FileEditorManager.getInstance((Project)project2).getSelectedFiles()) {
                if (!(file2 instanceof NewVirtualFile)) continue;
                files.add(file2);
            }
        }
        if (!files.isEmpty()) {
            RefreshQueue.getInstance().refresh(false, false, null, (Collection)files);
        }
    }

    public void blockSaveOnFrameDeactivation() {
        LOG.debug("save blocked");
        this.myBlockSaveOnFrameDeactivationCount.incrementAndGet();
    }

    public void unblockSaveOnFrameDeactivation() {
        this.myBlockSaveOnFrameDeactivationCount.decrementAndGet();
        LOG.debug("save unblocked");
    }

    public void blockSyncOnFrameActivation() {
        LOG.debug("sync blocked");
        this.myBlockSyncOnFrameActivationCount.incrementAndGet();
    }

    public void unblockSyncOnFrameActivation() {
        this.myBlockSyncOnFrameActivationCount.decrementAndGet();
        LOG.debug("sync unblocked");
    }
}

