/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.android.tools.analytics.UsageTracker;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.StudioCrash;
import com.google.wireless.android.sdk.stats.StudioExceptionDetails;
import com.google.wireless.android.sdk.stats.StudioPerformanceStats;
import com.google.wireless.android.sdk.stats.UIActionStats;
import com.intellij.concurrency.JobScheduler;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.ExceptionRegistry;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.StackTrace;
import com.intellij.ide.ThreadDumpsDatabase;
import com.intellij.ide.actions.CopyAction;
import com.intellij.ide.actions.CutAction;
import com.intellij.ide.actions.DeleteAction;
import com.intellij.ide.actions.NextOccurenceAction;
import com.intellij.ide.actions.PasteAction;
import com.intellij.ide.actions.PreviousOccurenceAction;
import com.intellij.ide.actions.SaveAllAction;
import com.intellij.ide.actions.UndoRedoAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.StatisticsUploadAssistant;
import com.intellij.internal.statistic.analytics.StudioCrashDetection;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.JdkBundle;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemHealthMonitor
extends ApplicationComponent.Adapter {
    private static final Logger LOG = Logger.getInstance(SystemHealthMonitor.class);
    private static final NotificationGroup GROUP = new NotificationGroup("System Health", NotificationDisplayType.STICKY_BALLOON, false);
    private static final NotificationGroup LOG_GROUP = NotificationGroup.logOnlyGroup((String)"System Health (minor)");
    private static final String SWITCH_JDK_ACTION = "SwitchBootJdk";
    private static final String LATEST_JDK_RELEASE = "1.8.0u112";
    public static final AtomicLong ourStudioActionCount = new AtomicLong(0L);
    private static final String STUDIO_ACTIVITY_COUNT = "studio.activity.count";
    private static final AtomicLong ourStudioExceptionCount = new AtomicLong(0L);
    private static final AtomicLong ourInitialPersistedExceptionCount = new AtomicLong(0L);
    private static final AtomicLong ourBundledPluginsExceptionCount = new AtomicLong(0L);
    private static final AtomicLong ourNonBundledPluginsExceptionCount = new AtomicLong(0L);
    private static final Object EXCEPTION_COUNT_LOCK = new Object();
    @NonNls
    private static final String STUDIO_EXCEPTION_COUNT_FILE = "studio.exc";
    @NonNls
    private static final String BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE = "studio.exb";
    @NonNls
    private static final String NON_BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE = "studio.exp";
    private final ThreadDumpsDatabase myThreadDumpsDatabase = new ThreadDumpsDatabase(new File(PathManager.getTempPath(), "threads.dmp"));
    private static final Object ACTION_INVOCATIONS_LOCK = new Object();
    private static Map<String, Multiset<UIActionStats.InvocationKind>> ourActionInvocations = new HashMap<String, Multiset<UIActionStats.InvocationKind>>();
    private final PropertiesComponent myProperties;
    private static final int INITIAL_DELAY_MINUTES = 1;
    private static final int INTERVAL_IN_MINUTES = 30;

    public SystemHealthMonitor(@NotNull PropertiesComponent properties) {
        this.myProperties = properties;
    }

    public void initComponent() {
        this.checkJvm();
        this.checkIBus();
        this.checkSignalBlocking();
        this.checkLauncherScript();
        SystemHealthMonitor.startDiskSpaceMonitoring();
        if (ApplicationManager.getApplication().isInternal() || StatisticsUploadAssistant.isSendAllowed()) {
            ourStudioActionCount.set(this.myProperties.getOrInitLong(STUDIO_ACTIVITY_COUNT, 0L));
            ourStudioExceptionCount.set(SystemHealthMonitor.getPersistedExceptionCount(STUDIO_EXCEPTION_COUNT_FILE));
            ourInitialPersistedExceptionCount.set(ourStudioExceptionCount.get());
            ourBundledPluginsExceptionCount.set(SystemHealthMonitor.getPersistedExceptionCount(BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE));
            ourNonBundledPluginsExceptionCount.set(SystemHealthMonitor.getPersistedExceptionCount(NON_BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE));
            StudioCrashDetection.updateRecordedVersionNumber((String)ApplicationInfo.getInstance().getStrictVersion());
            SystemHealthMonitor.startActivityMonitoring();
            SystemHealthMonitor.trackCrashes(StudioCrashDetection.reapCrashDescriptions());
            SystemHealthMonitor.trackPerfWatcherReports(this.myThreadDumpsDatabase.reapThreadDumps());
            Application application = ApplicationManager.getApplication();
            application.getMessageBus().connect((Disposable)application).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

                @Override
                public void appClosing() {
                    SystemHealthMonitor.this.myProperties.setValue(SystemHealthMonitor.STUDIO_ACTIVITY_COUNT, Long.toString(ourStudioActionCount.get()));
                    StudioCrashDetection.stop();
                    SystemHealthMonitor.reportActionInvocations();
                }
            });
            application.getMessageBus().connect((Disposable)application).subscribe(IdePerformanceListener.TOPIC, (Object)new IdePerformanceListener.Adapter(){

                public void uiFreezeFinished(int lengthInSeconds) {
                    UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.STUDIO_PERFORMANCE_STATS).setStudioPerformanceStats(StudioPerformanceStats.newBuilder().setUiFreezeTimeMs(lengthInSeconds * 1000)));
                }

                public void dumpedThreads(@NotNull File toFile, @NotNull ThreadDump dump) {
                    try {
                        SystemHealthMonitor.this.myThreadDumpsDatabase.appendThreadDump(toFile.toPath());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private void checkJvm() {
        JdkBundle bundle;
        try {
            Class.forName("com.sun.jdi.Value");
        }
        catch (Throwable t) {
            this.showNotification(new KeyHyperlinkAdapter("unsupported.jre"), new Object[0]);
        }
        if (StringUtil.containsIgnoreCase((String)System.getProperty("java.vm.name", ""), (String)"OpenJDK") && !SystemInfo.isJetbrainsJvm && !SystemInfo.isStudioJvm) {
            this.showNotification(new KeyHyperlinkAdapter("unsupported.jvm.openjdk.message"), new Object[0]);
        }
        if (StringUtil.endsWithIgnoreCase((String)System.getProperty("java.version", ""), (String)"-ea")) {
            this.showNotification(new KeyHyperlinkAdapter("unsupported.jvm.ea.message"), new Object[0]);
        }
        if ((bundle = JdkBundle.createBoot()) != null && !bundle.isBundled()) {
            Version version = bundle.getVersion();
            Integer updateNumber = bundle.getUpdateNumber();
            if (version != null && updateNumber != null && updateNumber < 112) {
                String bundleVersion = version.toCompactString() + "u" + updateNumber;
                boolean showSwitchOption = false;
                File bundledJDKAbsoluteLocation = JdkBundle.getBundledJDKAbsoluteLocation();
                if (bundledJDKAbsoluteLocation.exists() && bundle.getBitness() == Bitness.x64) {
                    JdkBundle bundledJdk;
                    if (SystemInfo.isMacIntel64) {
                        showSwitchOption = true;
                    } else if ((SystemInfo.isWindows || SystemInfo.isLinux) && (bundledJdk = JdkBundle.createBundle(bundledJDKAbsoluteLocation, false, false)) != null && bundledJdk.getVersion() != null) {
                        showSwitchOption = true;
                    }
                }
                if (showSwitchOption) {
                    this.showNotification(new KeyHyperlinkAdapter("outdated.jvm.version.message1"){

                        @Override
                        protected void hyperlinkActivated(HyperlinkEvent e) {
                            String url = e.getDescription();
                            if ("ack".equals(url)) {
                                SystemHealthMonitor.this.myProperties.setValue(this.getIgnoreKey(), "true");
                            } else if ("switch".equals(url)) {
                                ActionManager.getInstance().getAction(SystemHealthMonitor.SWITCH_JDK_ACTION).actionPerformed(null);
                            } else {
                                BrowserUtil.browse((String)url);
                            }
                        }
                    }, bundleVersion, LATEST_JDK_RELEASE);
                } else {
                    this.showNotification(new KeyHyperlinkAdapter("outdated.jvm.version.message2"), bundleVersion, LATEST_JDK_RELEASE);
                }
            }
        }
        if (SystemInfoRt.isMac && !SystemInfo.isJetbrainsJvm && !SystemInfo.isStudioJvm && SystemInfo.isJavaVersionAtLeast((String)"1.8.0_60") && !SystemInfo.isJavaVersionAtLeast((String)"1.8.0_76")) {
            this.showNotification(new KeyHyperlinkAdapter("unsupported.jvm.dragndrop.message"), new Object[0]);
        }
    }

    private void checkIBus() {
        String fix;
        Matcher m;
        String version;
        String xim;
        if (SystemInfo.isXWindow && (xim = System.getenv("XMODIFIERS")) != null && xim.contains("im=ibus") && (version = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"ibus-daemon", "--version"}))) != null && (m = Pattern.compile("ibus-daemon - Version ([0-9.]+)").matcher(version)).find() && StringUtil.compareVersionNumbers((String)m.group(1), (String)"1.5.11") < 0 && ((fix = System.getenv("IBUS_ENABLE_SYNC_MODE")) == null || fix.isEmpty() || fix.equals("0") || fix.equalsIgnoreCase("false"))) {
            this.showNotification(new KeyHyperlinkAdapter("ibus.blocking.warn.message"), new Object[0]);
        }
    }

    private static void trackPerfWatcherReports(@NotNull List<Path> threadDumps) {
        if (threadDumps.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> threadDumps.stream().limit(10L).forEach(t -> {
            List<String> lines;
            try {
                lines = Files.readAllLines(t);
            }
            catch (IOException e) {
                return;
            }
            SystemHealthMonitor.reportAnr(t.getFileName().toString(), lines);
        }));
    }

    public static void trackCrashes(@NotNull List<String> descriptions) {
        if (descriptions.isEmpty()) {
            return;
        }
        SystemHealthMonitor.reportCrashes(descriptions);
        SystemHealthMonitor.trackExceptionsAndActivity(0L, 0L, 0L, 0L, descriptions.size(), Collections.emptyList());
    }

    public static void trackExceptionsAndActivity(long activityCount, long exceptionCount, long bundledPluginExceptionCount, long nonBundledPluginExceptionCount, long fatalExceptionCount, @NotNull List<StackTrace> stackTraces) {
        if (!StatisticsUploadAssistant.isSendAllowed()) {
            return;
        }
        if (!ApplicationManager.getApplication().isInternal()) {
            List allDetails = stackTraces.stream().map(t -> StudioExceptionDetails.newBuilder().setHash(t.md5string()).setCount(t.count()).setSummary(t.summarize(20)).build()).collect(Collectors.toList());
            UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PING).setKind(AndroidStudioEvent.EventKind.STUDIO_CRASH).setStudioCrash(StudioCrash.newBuilder().setActions(activityCount).setExceptions(exceptionCount).setBundledPluginExceptions(bundledPluginExceptionCount).setNonBundledPluginExceptions(nonBundledPluginExceptionCount).setCrashes(fatalExceptionCount).addAllDetails(allDetails)));
        }
    }

    private void checkSignalBlocking() {
        if (SystemInfo.isUnix) {
            try {
                LibC lib = (LibC)Native.loadLibrary((String)"c", LibC.class);
                Memory buf = new Memory(1024L);
                if (lib.sigaction(2, null, (Pointer)buf) == 0) {
                    long handler2;
                    long l = handler2 = Native.POINTER_SIZE == 8 ? buf.getLong(0L) : (long)buf.getInt(0L);
                    if (handler2 == 1L) {
                        this.showNotification(new KeyHyperlinkAdapter("ide.sigint.ignored.message"), new Object[0]);
                    }
                }
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
        }
    }

    private void checkLauncherScript() {
        if (SystemInfo.isXWindow && System.getProperty("jb.restart.code") != null) {
            this.showNotification(new KeyHyperlinkAdapter("ide.launcher.script.outdated"), new Object[0]);
        }
    }

    private void showNotification(final KeyHyperlinkAdapter keyHyperlinkAdapter, Object ... params) {
        String key2 = keyHyperlinkAdapter.getKey();
        String ignoreKey = keyHyperlinkAdapter.getIgnoreKey();
        boolean ignored = this.myProperties.isValueSet(ignoreKey);
        LOG.info("issue detected: " + key2 + (ignored ? " (ignored)" : ""));
        if (ignored) {
            return;
        }
        final String message2 = IdeBundle.message((String)key2, (Object[])params) + (key2.equals("unsupported.jre") ? "" : IdeBundle.message((String)"sys.health.acknowledge.link", (Object[])new Object[0]));
        final Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appStarting(@Nullable Project projectFromCommandLine) {
                app.invokeLater(() -> {
                    JRootPane component = WindowManager.getInstance().findVisibleFrame().getRootPane();
                    if (component != null) {
                        Rectangle rect = component.getVisibleRect();
                        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message2, MessageType.WARNING, (HyperlinkListener)((Object)keyHyperlinkAdapter)).setFadeoutTime(-1L).setHideOnFrameResize(false).setHideOnLinkClick(true).setDisposable((Disposable)app).createBalloon().show(new RelativePoint((Component)component, new Point(rect.x + 30, rect.y + rect.height - 10)), Balloon.Position.above);
                    }
                    Notification notification = LOG_GROUP.createNotification(message2, NotificationType.WARNING);
                    notification.setImportant(true);
                    Notifications.Bus.notify((Notification)notification);
                });
            }
        });
    }

    private static void startDiskSpaceMonitoring() {
        if (SystemProperties.getBooleanProperty((String)"idea.no.system.path.space.monitoring", (boolean)false)) {
            return;
        }
        final File file2 = new File(PathManager.getSystemPath());
        final AtomicBoolean reported = new AtomicBoolean();
        final ThreadLocal ourFreeSpaceCalculation = new ThreadLocal();
        JobScheduler.getScheduler().schedule(new Runnable(){
            private static final long LOW_DISK_SPACE_THRESHOLD = 0x3200000L;
            private static final long MAX_WRITE_SPEED_IN_BPS = 524288000L;

            @Override
            public void run() {
                if (!reported.get()) {
                    Future future2 = (Future)ourFreeSpaceCalculation.get();
                    if (future2 == null) {
                        future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                            long fileUsableSpace = file2.getUsableSpace();
                            while (fileUsableSpace == 0L) {
                                TimeoutUtil.sleep((long)5000L);
                                fileUsableSpace = file2.getUsableSpace();
                            }
                            return fileUsableSpace;
                        });
                        ourFreeSpaceCalculation.set(future2);
                    }
                    if (!future2.isDone() || future2.isCancelled()) {
                        JobScheduler.getScheduler().schedule(this, 1L, TimeUnit.SECONDS);
                        return;
                    }
                    try {
                        long fileUsableSpace = (Long)future2.get();
                        long timeout = Math.max(5L, (fileUsableSpace - 0x3200000L) / 524288000L);
                        ourFreeSpaceCalculation.set(null);
                        if (fileUsableSpace < 0x3200000L) {
                            if (ReadAction.compute(() -> NotificationsConfiguration.getNotificationsConfiguration()) == null) {
                                ourFreeSpaceCalculation.set(future2);
                                JobScheduler.getScheduler().schedule(this, 1L, TimeUnit.SECONDS);
                                return;
                            }
                            reported.compareAndSet(false, true);
                            SwingUtilities.invokeLater(() -> {
                                String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                                String message2 = IdeBundle.message((String)"low.disk.space.message", (Object[])new Object[]{productName});
                                if (fileUsableSpace < 102400L) {
                                    LOG.warn(message2 + " (" + fileUsableSpace + ")");
                                    Messages.showErrorDialog((String)message2, (String)"Fatal Configuration Problem");
                                    reported.compareAndSet(true, false);
                                    this.restart(timeout);
                                } else {
                                    GROUP.createNotification(message2, file2.getPath(), NotificationType.ERROR, null).whenExpired(() -> {
                                        reported.compareAndSet(true, false);
                                        this.restart(timeout);
                                    }).notify(null);
                                }
                            });
                        } else {
                            this.restart(timeout);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Throwable)ex);
                    }
                }
            }

            private void restart(long timeout) {
                JobScheduler.getScheduler().schedule(this, timeout, TimeUnit.SECONDS);
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private static void startActivityMonitoring() {
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
            long activityCount = ourStudioActionCount.getAndSet(0L);
            long exceptionCount = ourStudioExceptionCount.getAndSet(0L);
            long bundledPluginExceptionCount = ourBundledPluginsExceptionCount.getAndSet(0L);
            long nonBundledPluginExceptionCount = ourNonBundledPluginsExceptionCount.getAndSet(0L);
            SystemHealthMonitor.persistExceptionCount(0L, STUDIO_EXCEPTION_COUNT_FILE);
            SystemHealthMonitor.persistExceptionCount(0L, BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE);
            SystemHealthMonitor.persistExceptionCount(0L, NON_BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE);
            if (ApplicationManager.getApplication().isInternal()) assert (SystemHealthMonitor.getPersistedExceptionCount(STUDIO_EXCEPTION_COUNT_FILE) < 5L);
            if (activityCount > 0L || exceptionCount > 0L) {
                List<StackTrace> traces = ExceptionRegistry.INSTANCE.getStackTraces(0);
                ExceptionRegistry.INSTANCE.clear();
                SystemHealthMonitor.trackExceptionsAndActivity(activityCount, exceptionCount, bundledPluginExceptionCount, nonBundledPluginExceptionCount, 0L, traces);
            }
            SystemHealthMonitor.reportActionInvocations();
        }, 1L, 30L, TimeUnit.MINUTES);
    }

    public static void incrementAndSaveExceptionCount() {
        SystemHealthMonitor.persistExceptionCount(ourStudioExceptionCount.incrementAndGet(), STUDIO_EXCEPTION_COUNT_FILE);
        if (ApplicationManager.getApplication().isInternal()) assert (Math.abs(SystemHealthMonitor.getPersistedExceptionCount(STUDIO_EXCEPTION_COUNT_FILE) - ourStudioExceptionCount.get()) < 5L);
    }

    public static void incrementAndSaveBundledPluginsExceptionCount() {
        SystemHealthMonitor.persistExceptionCount(ourBundledPluginsExceptionCount.incrementAndGet(), BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE);
    }

    public static void incrementAndSaveNonBundledPluginsExceptionCount() {
        SystemHealthMonitor.persistExceptionCount(ourNonBundledPluginsExceptionCount.incrementAndGet(), NON_BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void persistExceptionCount(long count, @NotNull String countFileName) {
        Object object = EXCEPTION_COUNT_LOCK;
        synchronized (object) {
            try {
                File f = new File(PathManager.getTempPath(), countFileName);
                com.google.common.io.Files.write((CharSequence)Long.toString(count), (File)f, (Charset)Charsets.UTF_8);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getPersistedExceptionCount(@NotNull String countFileName) {
        Object object = EXCEPTION_COUNT_LOCK;
        synchronized (object) {
            try {
                File f = new File(PathManager.getTempPath(), countFileName);
                String contents = com.google.common.io.Files.toString((File)f, (Charset)Charsets.UTF_8);
                return Long.parseLong(contents);
            }
            catch (Throwable t) {
                return 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void countActionInvocation(@NotNull Class actionClass, @NotNull Presentation templatePresentation, @NotNull AnActionEvent event) {
        Object object = ACTION_INVOCATIONS_LOCK;
        synchronized (object) {
            String actionName = SystemHealthMonitor.getActionName(actionClass, templatePresentation);
            UIActionStats.InvocationKind invocationKind = SystemHealthMonitor.getInvocationKindFromEvent(event);
            if (SystemHealthMonitor.shouldAggregate(actionClass)) {
                LinkedHashMultiset invocations = ourActionInvocations.get(actionName);
                if (invocations == null) {
                    invocations = LinkedHashMultiset.create();
                    ourActionInvocations.put(actionName, (Multiset<UIActionStats.InvocationKind>)invocations);
                }
                invocations.add((Object)invocationKind);
            } else {
                UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.STUDIO_UI).setKind(AndroidStudioEvent.EventKind.STUDIO_UI_ACTION_STATS).setUiActionStats(UIActionStats.newBuilder().setActionClassName(actionName).setInvocationKind(invocationKind).setInvocations(1L).setDirect(true)));
            }
        }
    }

    private static boolean shouldAggregate(Class actionClass) {
        return EditorAction.class.isAssignableFrom(actionClass) || UndoRedoAction.class.isAssignableFrom(actionClass) || PasteAction.class.isAssignableFrom(actionClass) || CopyAction.class.isAssignableFrom(actionClass) || CutAction.class.isAssignableFrom(actionClass) || SaveAllAction.class.isAssignableFrom(actionClass) || DeleteAction.class.isAssignableFrom(actionClass) || NextOccurenceAction.class.isAssignableFrom(actionClass) || PreviousOccurenceAction.class.isAssignableFrom(actionClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reportActionInvocations() {
        Map<String, Multiset<UIActionStats.InvocationKind>> currentInvocations = null;
        Iterator<Map.Entry<String, Multiset<UIActionStats.InvocationKind>>> iterator = ACTION_INVOCATIONS_LOCK;
        synchronized (iterator) {
            currentInvocations = ourActionInvocations;
            ourActionInvocations = new HashMap<String, Multiset<UIActionStats.InvocationKind>>();
        }
        for (Map.Entry<String, Multiset<UIActionStats.InvocationKind>> actionEntry : currentInvocations.entrySet()) {
            for (Multiset.Entry invocationEntry : actionEntry.getValue().entrySet()) {
                UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.STUDIO_UI).setKind(AndroidStudioEvent.EventKind.STUDIO_UI_ACTION_STATS).setUiActionStats(UIActionStats.newBuilder().setActionClassName(actionEntry.getKey()).setInvocationKind((UIActionStats.InvocationKind)invocationEntry.getElement()).setInvocations((long)invocationEntry.getCount())));
            }
        }
    }

    private static UIActionStats.InvocationKind getInvocationKindFromEvent(AnActionEvent event) {
        if (event.getInputEvent() instanceof KeyEvent) {
            return UIActionStats.InvocationKind.KEYBOARD_SHORTCUT;
        }
        String place = event.getPlace();
        if (place.contains("Menu")) {
            return UIActionStats.InvocationKind.MENU;
        }
        if (place.contains("Toolbar")) {
            return UIActionStats.InvocationKind.TOOLBAR;
        }
        if (event.getInputEvent() instanceof MouseEvent) {
            return UIActionStats.InvocationKind.MOUSE;
        }
        return UIActionStats.InvocationKind.UNKNOWN_INVOCATION_KIND;
    }

    static String getActionName(@NotNull Class actionClass, @NotNull Presentation templatePresentation) {
        Class<?> currentClass = actionClass;
        while (currentClass.isAnonymousClass()) {
            currentClass = currentClass.getEnclosingClass();
        }
        String packageName = currentClass.getPackage().getName();
        if (packageName.startsWith("com.android.") || packageName.startsWith("com.intellij.") || packageName.startsWith("org.jetbrains.") || packageName.startsWith("or.intellij.") || packageName.startsWith("com.jetbrains.") || packageName.startsWith("git4idea.")) {
            String actionName = currentClass.getSimpleName();
            if (actionName.equals("ExecutorAction")) {
                actionName = actionName + "#" + templatePresentation.getText();
            }
            return actionName;
        }
        return currentClass.getCanonicalName();
    }

    public static void reportException(@NotNull Throwable t, @NotNull StackTrace stackTrace) {
        if (!UsageTracker.getInstance().getAnalyticsSettings().hasOptedIn()) {
            return;
        }
        ErrorReportSubmitter reporter = IdeErrorsDialog.getAndroidErrorReporter();
        if (reporter != null) {
            AndroidStudioExceptionEvent e = new AndroidStudioExceptionEvent(t.getMessage(), t, stackTrace);
            reporter.submit(new IdeaLoggingEvent[]{e}, null, null, info -> {});
        }
    }

    private static void reportAnr(@NotNull String fileName, @NotNull List<String> threadDump) {
        if (!UsageTracker.getInstance().getAnalyticsSettings().hasOptedIn()) {
            return;
        }
        ErrorReportSubmitter reporter = IdeErrorsDialog.getAndroidErrorReporter();
        if (reporter != null) {
            AndroidStudioAnrEvent e = new AndroidStudioAnrEvent(fileName, Joiner.on((char)'\n').join(threadDump));
            reporter.submit(new IdeaLoggingEvent[]{e}, null, null, info -> {});
        }
    }

    private static void reportCrashes(@NotNull List<String> descriptions) {
        if (!UsageTracker.getInstance().getAnalyticsSettings().hasOptedIn()) {
            return;
        }
        ErrorReportSubmitter reporter = IdeErrorsDialog.getAndroidErrorReporter();
        if (reporter != null) {
            AndroidStudioCrashEvents e = new AndroidStudioCrashEvents(descriptions);
            reporter.submit(new IdeaLoggingEvent[]{e}, null, null, info -> {});
        }
    }

    class KeyHyperlinkAdapter
    extends HyperlinkAdapter {
        private final String key;

        KeyHyperlinkAdapter(String key2) {
            this.key = key2;
        }

        public String getKey() {
            return this.key;
        }

        public String getIgnoreKey() {
            return "ignore." + this.key;
        }

        protected void hyperlinkActivated(HyperlinkEvent e) {
            String url = e.getDescription();
            if ("ack".equals(url)) {
                SystemHealthMonitor.this.myProperties.setValue(this.getIgnoreKey(), "true");
            } else {
                BrowserUtil.browse((String)url);
            }
        }
    }

    private static interface LibC
    extends Library {
        public static final int SIGINT = 2;
        public static final long SIG_IGN = 1L;

        public int sigaction(int var1, Pointer var2, Pointer var3);
    }

    private static class AndroidStudioCrashEvents
    extends IdeaLoggingEvent {
        private List<String> myDescriptions;

        public AndroidStudioCrashEvents(@NotNull List<String> descriptions) {
            super("", null);
            this.myDescriptions = descriptions;
        }

        @Nullable
        public Object getData() {
            return ImmutableMap.of((Object)"Type", (Object)"Crashes", (Object)"descriptions", this.myDescriptions);
        }
    }

    private static class AndroidStudioAnrEvent
    extends IdeaLoggingEvent {
        private final String myFileName;
        private final String myThreadDump;

        public AndroidStudioAnrEvent(@NotNull String fileName, @NotNull String threadDump) {
            super("", null);
            this.myFileName = fileName;
            this.myThreadDump = threadDump;
        }

        @Nullable
        public Object getData() {
            return ImmutableMap.of((Object)"Type", (Object)"ANR", (Object)"file", (Object)this.myFileName, (Object)"threadDump", (Object)this.myThreadDump);
        }
    }

    private static class AndroidStudioExceptionEvent
    extends IdeaLoggingEvent {
        private final StackTrace myStackTrace;

        public AndroidStudioExceptionEvent(String message2, Throwable throwable, @NotNull StackTrace stackTrace) {
            super(message2, throwable);
            this.myStackTrace = stackTrace;
        }

        @Nullable
        public Object getData() {
            return ImmutableMap.of((Object)"Type", (Object)"Exception", (Object)"md5", (Object)this.myStackTrace.md5string(), (Object)"summary", (Object)this.myStackTrace.summarize(50));
        }
    }
}

