/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ThreadDumpsDatabase {
    private final Object myDbLock = new Object();
    private final Path myDb;

    public ThreadDumpsDatabase(@NotNull File databaseFile) {
        this.myDb = databaseFile.toPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendThreadDump(@NotNull Path threadDumpPath) throws IOException {
        String content = threadDumpPath.toString() + "\n";
        Object object = this.myDbLock;
        synchronized (object) {
            Files.write(this.myDb, content.getBytes(Charsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Path> reapThreadDumps() {
        List<String> lines;
        Object object = this.myDbLock;
        synchronized (object) {
            try {
                lines = Files.readAllLines(this.myDb);
                Files.write(this.myDb, new byte[0], StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                return ImmutableList.of();
            }
        }
        return lines.stream().map(String::trim).filter(line -> !line.isEmpty()).map(x$0 -> Paths.get(x$0, new String[0])).filter(Files::isReadable).collect(Collectors.toList());
    }
}

