/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiActivityMonitorImpl
extends UiActivityMonitor
implements ModalityStateListener,
Disposable {
    private final FactoryMap<Project, BusyContainer> myObjects = new FactoryMap<Project, BusyContainer>(){

        protected BusyContainer create(Project key2) {
            if (this.isEmpty()) {
                UiActivityMonitorImpl.this.installListener();
            }
            return key2 == null ? new BusyContainer(null) : new BusyContainer(null){

                @Override
                @NotNull
                protected BusyImpl createBusyImpl(@NotNull Set<UiActivity> key2) {
                    return new BusyImpl(key2, this){

                        @Override
                        public boolean isReady() {
                            for (Map.Entry entry : UiActivityMonitorImpl.this.myObjects.entrySet()) {
                                BusyContainer eachContainer = (BusyContainer)entry.getValue();
                                BusyImpl busy = eachContainer.getOrCreateBusy(this.myToWatchArray);
                                if (busy == this || busy.isOwnReady()) continue;
                                return false;
                            }
                            return this.isOwnReady();
                        }
                    };
                }
            };
        }
    };
    private boolean myActive;
    @NotNull
    private final BusyObject myEmptyBusy = new BusyObject.Impl(){

        public boolean isReady() {
            return true;
        }
    };

    public void installListener() {
        LaterInvocator.addModalityStateListener(this, this);
    }

    public void dispose() {
        this.myObjects.clear();
    }

    public void beforeModalityStateChanged(boolean entering) {
        SwingUtilities.invokeLater(() -> this.maybeReady());
    }

    public void maybeReady() {
        for (BusyContainer each : this.myObjects.values()) {
            each.onReady();
        }
    }

    @NotNull
    public BusyObject getBusy(@NotNull Project project2, UiActivity ... toWatch) {
        if (!this.isActive()) {
            return this.myEmptyBusy;
        }
        return this._getBusy(project2, toWatch);
    }

    @NotNull
    public BusyObject getBusy(UiActivity ... toWatch) {
        if (!this.isActive()) {
            return this.myEmptyBusy;
        }
        return this._getBusy(null, toWatch);
    }

    public void addActivity(@NotNull Project project2, @NotNull UiActivity activity) {
        this.addActivity(project2, activity, UiActivityMonitorImpl.getDefaultModalityState());
    }

    public void addActivity(@NotNull Project project2, @NotNull UiActivity activity, @NotNull ModalityState effectiveModalityState) {
        if (!this.isActive()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> this.getBusyContainer(project2).addActivity(activity, effectiveModalityState));
    }

    public void removeActivity(@NotNull Project project2, @NotNull UiActivity activity) {
        if (!this.isActive()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> this._getBusy(project2, new UiActivity[0]).removeActivity(activity));
    }

    public void addActivity(@NotNull UiActivity activity) {
        this.addActivity(activity, UiActivityMonitorImpl.getDefaultModalityState());
    }

    private static ModalityState getDefaultModalityState() {
        return ApplicationManager.getApplication().getNoneModalityState();
    }

    public void addActivity(@NotNull UiActivity activity, @NotNull ModalityState effectiveModalityState) {
        if (!this.isActive()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> this.getBusyContainer(null).addActivity(activity, effectiveModalityState));
    }

    public void removeActivity(@NotNull UiActivity activity) {
        if (!this.isActive()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> this._getBusy(null, new UiActivity[0]).removeActivity(activity));
    }

    @NotNull
    private BusyImpl _getBusy(@Nullable Project key2, UiActivity ... toWatch) {
        return this.getBusyContainer(key2).getOrCreateBusy(toWatch);
    }

    @NotNull
    private BusyContainer getBusyContainer(@Nullable Project key2) {
        BusyContainer container = (BusyContainer)this.myObjects.get((Object)key2);
        return container != null ? container : this.getGlobalBusy();
    }

    void initBusyObjectFor(@Nullable Project key2) {
        this.myObjects.put((Object)key2, (Object)new BusyContainer(key2));
    }

    boolean hasObjectFor(Project project2) {
        return this.myObjects.containsKey((Object)project2);
    }

    private BusyContainer getGlobalBusy() {
        return (BusyContainer)this.myObjects.get(null);
    }

    public void clear() {
        Set keys = this.myObjects.keySet();
        for (Project each : keys) {
            ((BusyContainer)this.myObjects.get((Object)each)).clear();
        }
    }

    public void setActive(boolean active) {
        if (this.myActive == active) {
            return;
        }
        if (this.myActive) {
            this.clear();
        }
        this.myActive = active;
    }

    public boolean isActive() {
        return this.myActive;
    }

    @NotNull
    protected ModalityState getCurrentState() {
        return ModalityState.current();
    }

    public class BusyContainer
    implements Disposable {
        private final Map<Set<UiActivity>, BusyImpl> myActivities2Object = new HashMap<Set<UiActivity>, BusyImpl>();
        private final Map<BusyImpl, Set<UiActivity>> myObject2Activities = new HashMap<BusyImpl, Set<UiActivity>>();
        private final Set<UiActivity> myActivities = new HashSet<UiActivity>();
        private boolean myRemovingActivityNow;
        @Nullable
        private final Project myProject;

        public BusyContainer(Project project2) {
            this.myProject = project2;
            this.registerBusyObject(new HashSet<UiActivity>());
            if (project2 != null) {
                Disposer.register((Disposable)project2, (Disposable)this);
            }
        }

        @NotNull
        public BusyImpl getOrCreateBusy(UiActivity ... activities) {
            HashSet<UiActivity> key2 = new HashSet<UiActivity>();
            key2.addAll(Arrays.asList(activities));
            if (this.myActivities2Object.containsKey(key2)) {
                return this.myActivities2Object.get(key2);
            }
            return this.registerBusyObject(key2);
        }

        @NotNull
        private BusyImpl registerBusyObject(@NotNull Set<UiActivity> key2) {
            BusyImpl busy = this.createBusyImpl(key2);
            this.myActivities2Object.put(key2, busy);
            this.myObject2Activities.put(busy, key2);
            return busy;
        }

        @NotNull
        protected BusyImpl createBusyImpl(@NotNull Set<UiActivity> key2) {
            return new BusyImpl(key2, this);
        }

        public void onReady() {
            Iterator<Set<UiActivity>> keyIterator = this.myActivities2Object.keySet().iterator();
            while (keyIterator.hasNext()) {
                Set<UiActivity> eachKey = keyIterator.next();
                BusyImpl busy = this.myActivities2Object.get(eachKey);
                busy.onReady();
                if (!busy.isReady()) continue;
                keyIterator.remove();
                this.myObject2Activities.remove((Object)busy);
            }
        }

        public void clear() {
            UiActivity[] activities;
            for (UiActivity each : activities = this.myActivities.toArray(new UiActivity[this.myActivities.size()])) {
                UiActivityMonitorImpl.this.removeActivity(each);
            }
        }

        public void onActivityAdded(@NotNull UiActivity activity) {
            this.myActivities.add(activity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onActivityRemoved(@NotNull BusyImpl busy, @NotNull UiActivity activity) {
            Set<UiActivity> activities;
            if (this.myRemovingActivityNow) {
                return;
            }
            HashMap<BusyImpl, Set<UiActivity>> toRemove = new HashMap<BusyImpl, Set<UiActivity>>();
            try {
                this.myRemovingActivityNow = true;
                this.myActivities.remove(activity);
                for (BusyImpl each : this.myObject2Activities.keySet()) {
                    if (each != busy) {
                        each.removeActivity(activity);
                    }
                    if (!each.isReady()) continue;
                    activities = this.myObject2Activities.get((Object)busy);
                    toRemove.put(busy, activities);
                }
            }
            catch (Throwable throwable) {
                for (BusyImpl each : toRemove.keySet()) {
                    Set<UiActivity> activities2 = this.myObject2Activities.remove((Object)each);
                    this.myActivities2Object.remove(activities2);
                }
                this.myRemovingActivityNow = false;
                throw throwable;
            }
            for (BusyImpl each : toRemove.keySet()) {
                activities = this.myObject2Activities.remove((Object)each);
                this.myActivities2Object.remove(activities);
            }
            this.myRemovingActivityNow = false;
        }

        public void addActivity(@NotNull UiActivity activity, @NotNull ModalityState state) {
            this.getOrCreateBusy(activity);
            Set<BusyImpl> busies = this.myObject2Activities.keySet();
            for (BusyImpl each : busies) {
                each.addActivity(activity, state);
            }
        }

        public void dispose() {
            UiActivityMonitorImpl.this.myObjects.remove((Object)this.myProject);
        }
    }

    private class BusyImpl
    extends BusyObject.Impl {
        private final Map<UiActivity, ActivityInfo> myActivities = new HashMap<UiActivity, ActivityInfo>();
        private final Set<UiActivity> myQueuedToRemove = new HashSet<UiActivity>();
        protected final Set<UiActivity> myToWatch;
        protected final UiActivity[] myToWatchArray;
        private final BusyContainer myContainer;

        private BusyImpl(@NotNull Set<UiActivity> toWatch, BusyContainer container) {
            this.myToWatch = toWatch;
            this.myToWatchArray = toWatch.toArray(new UiActivity[toWatch.size()]);
            this.myContainer = container;
        }

        public boolean isReady() {
            return this.isOwnReady() && UiActivityMonitorImpl.this.getGlobalBusy().getOrCreateBusy(this.myToWatchArray).isOwnReady();
        }

        boolean isOwnReady() {
            HashMap<UiActivity, ActivityInfo> infoToCheck = new HashMap<UiActivity, ActivityInfo>();
            for (Set eachActivitySet : this.myContainer.myActivities2Object.keySet()) {
                BusyImpl eachBusyObject = (BusyImpl)((Object)this.myContainer.myActivities2Object.get(eachActivitySet));
                if (eachBusyObject == this) continue;
                for (UiActivity eachOtherActivity : eachActivitySet) {
                    for (UiActivity eachToWatch : this.myToWatch) {
                        if (!eachToWatch.isSameOrGeneralFor(eachOtherActivity) || !eachBusyObject.myActivities.containsKey(eachOtherActivity)) continue;
                        infoToCheck.put(eachOtherActivity, eachBusyObject.myActivities.get(eachOtherActivity));
                    }
                }
            }
            infoToCheck.putAll(this.myActivities);
            if (infoToCheck.isEmpty()) {
                return true;
            }
            ModalityState current = UiActivityMonitorImpl.this.getCurrentState();
            for (Map.Entry entry : infoToCheck.entrySet()) {
                ActivityInfo info = (ActivityInfo)entry.getValue();
                if (current.dominates(info.getEffectiveState())) continue;
                return false;
            }
            return true;
        }

        public void addActivity(@NotNull UiActivity activity, @NotNull ModalityState effectiveModalityState) {
            if (!this.myToWatch.isEmpty() && !this.myToWatch.contains(activity)) {
                return;
            }
            this.myActivities.put(activity, new ActivityInfo(effectiveModalityState));
            this.myQueuedToRemove.remove(activity);
            this.myContainer.onActivityAdded(activity);
        }

        public void removeActivity(@NotNull UiActivity activity) {
            if (!this.myActivities.containsKey(activity)) {
                return;
            }
            this.myQueuedToRemove.add(activity);
            Runnable runnable2 = () -> {
                if (!this.myQueuedToRemove.contains(activity)) {
                    return;
                }
                this.myQueuedToRemove.remove(activity);
                this.myActivities.remove(activity);
                this.myContainer.onActivityRemoved(this, activity);
                this.onReady();
            };
            SwingUtilities.invokeLater(runnable2);
        }
    }

    private static class ActivityInfo {
        private final ModalityState myEffectiveState;

        private ActivityInfo(@NotNull ModalityState effectiveState) {
            this.myEffectiveState = effectiveState;
        }

        @NotNull
        public ModalityState getEffectiveState() {
            return this.myEffectiveState;
        }
    }
}

