/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.util.PsiUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;

public class CreateModuleInfoAction
extends CreateFromTemplateActionBase {
    public CreateModuleInfoAction() {
        super(IdeBundle.message((String)"action.create.new.module-info.title", (Object[])new Object[0]), IdeBundle.message((String)"action.create.new.module-info.description", (Object[])new Object[0]), AllIcons.FileTypes.Java);
    }

    public void update(@NotNull AnActionEvent e) {
        DataContext ctx = e.getDataContext();
        boolean available = Optional.ofNullable(LangDataKeys.IDE_VIEW.getData(ctx)).map(view -> this.getTargetDirectory(ctx, (IdeView)view)).filter(PsiUtil::isLanguageLevel9OrHigher).map(ModuleUtilCore::findModuleForPsiElement).map(module2 -> FilenameIndex.getVirtualFilesByName(module2.getProject(), "module-info.java", module2.getModuleScope(false)).isEmpty()).orElse(false);
        e.getPresentation().setEnabledAndVisible(available);
    }

    @Override
    @Nullable
    protected PsiDirectory getTargetDirectory(DataContext ctx, IdeView view) {
        ProjectFileIndex index;
        PsiDirectory psiDir;
        VirtualFile vDir;
        PsiDirectory[] directories = view.getDirectories();
        if (directories.length == 1 && (vDir = (psiDir = directories[0]).getVirtualFile()).equals((index = ProjectRootManager.getInstance((Project)psiDir.getProject()).getFileIndex()).getSourceRootForFile(vDir)) && index.isUnderSourceRootOfType(vDir, Collections.singleton(JavaSourceRootType.SOURCE))) {
            return psiDir;
        }
        return null;
    }

    @Override
    protected FileTemplate getTemplate(@NotNull Project project2, @NotNull PsiDirectory dir) {
        return FileTemplateManager.getInstance(project2).getInternalTemplate("module-info");
    }

    @Override
    protected AttributesDefaults getAttributesDefaults(@NotNull DataContext ctx) {
        return new AttributesDefaults("module-info").withFixedName(true);
    }

    @Override
    protected Map<String, String> getLiveTemplateDefaults(@NotNull DataContext ctx, @NotNull PsiFile file2) {
        Module module2 = (Module)LangDataKeys.MODULE.getData(ctx);
        return Collections.singletonMap("MODULE_NAME", module2 != null ? LightJavaModule.moduleName(module2.getName()) : "module_name");
    }
}

