/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.CutProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;

public class CutAction
extends AnAction
implements DumbAware {
    public CutAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        CutProvider provider2 = CutAction.getAvailableCutProvider(e);
        if (provider2 == null) {
            return;
        }
        provider2.performCut(e.getDataContext());
    }

    private static CutProvider getAvailableCutProvider(AnActionEvent e) {
        CutProvider provider2 = (CutProvider)PlatformDataKeys.CUT_PROVIDER.getData(e.getDataContext());
        Project project2 = e.getProject();
        if (project2 != null && DumbService.isDumb((Project)project2) && !DumbService.isDumbAware((Object)provider2)) {
            return null;
        }
        return provider2;
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        CutProvider provider2 = CutAction.getAvailableCutProvider(event);
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        presentation.setEnabled(project2 != null && project2.isOpen() && provider2 != null && provider2.isCutEnabled(dataContext));
        if (event.getPlace().equals("EditorPopup") && provider2 != null) {
            presentation.setVisible(provider2.isCutVisible(dataContext));
        } else {
            presentation.setVisible(true);
        }
    }
}

