/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.util.ExportToFileUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;

public class ExportToTextFileAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        ExporterToTextFile exporterToTextFile = this.getExporter(dataContext);
        if (project2 == null || exporterToTextFile == null) {
            return;
        }
        if (!exporterToTextFile.canExport()) {
            return;
        }
        ExportToTextFileAction.export(project2, exporterToTextFile);
    }

    public static void export(Project project2, ExporterToTextFile exporter) {
        ExportToFileUtil.ExportDialogBase dlg = new ExportToFileUtil.ExportDialogBase(project2, exporter);
        if (!dlg.showAndGet()) {
            return;
        }
        ExportToFileUtil.exportTextToFile(project2, dlg.getFileName(), dlg.getText());
        exporter.exportedTo(dlg.getFileName());
    }

    protected ExporterToTextFile getExporter(DataContext dataContext) {
        return (ExporterToTextFile)PlatformDataKeys.EXPORTER_TO_TEXT_FILE.getData(dataContext);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        ExporterToTextFile exporterToTextFile = this.getExporter(dataContext);
        presentation.setEnabled(CommonDataKeys.PROJECT.getData(dataContext) != null && exporterToTextFile != null && exporterToTextFile.canExport());
    }
}

