/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.actions.SelectInContextImpl;
import com.intellij.ide.impl.ProjectPaneSelectInTarget;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public class SelectInProjectViewAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        ProjectPaneSelectInTarget target = new ProjectPaneSelectInTarget(e.getProject());
        SelectInContext context = SelectInContextImpl.createContext(e);
        if (context != null) {
            target.selectIn(context, true);
        }
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 != null) {
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        }
        super.beforeActionPerformedUpdate(e);
    }

    public void update(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 != null) {
            ProjectPaneSelectInTarget target = new ProjectPaneSelectInTarget(project2);
            SelectInContext context = SelectInContextImpl.createContext(e);
            if (context != null && target.canSelect(context)) {
                e.getPresentation().setEnabled(true);
                return;
            }
        }
        e.getPresentation().setEnabled(false);
    }
}

