/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfo;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ShowSettingsAction
extends AnAction
implements DumbAware {
    public ShowSettingsAction() {
        super(CommonBundle.settingsAction(), CommonBundle.settingsActionDescription(), AllIcons.General.Settings);
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(!SystemInfo.isMac || !"MainMenu".equals(e.getPlace()));
        if (SystemInfo.isMac && ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace())) {
            e.getPresentation().setVisible(false);
        }
        if (e.getPlace().equals("WelcomeScreen")) {
            e.getPresentation().setText(CommonBundle.settingsTitle());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = e.getProject();
        ShowSettingsAction.perform(project2 != null ? project2 : ProjectManager.getInstance().getDefaultProject());
    }

    public static void perform(@NotNull Project project2) {
        long startTime = System.nanoTime();
        SwingUtilities.invokeLater(() -> {
            long endTime = System.nanoTime();
            if (ApplicationManagerEx.getApplicationEx().isInternal()) {
                System.out.println("Displaying settings dialog took " + (endTime - startTime) / 1000000L + " ms");
            }
        });
        ShowSettingsUtil.getInstance().showSettingsDialog(project2, ShowSettingsUtilImpl.getConfigurableGroups(project2, true));
    }
}

