/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.newEditor.SettingsDialogFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Composite;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowSettingsUtilImpl
extends ShowSettingsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.ShowSettingsUtilImpl");

    @NotNull
    private static Project getProject(@Nullable Project project2) {
        return project2 != null ? project2 : ProjectManager.getInstance().getDefaultProject();
    }

    @NotNull
    public static DialogWrapper getDialog(@Nullable Project project2, @NotNull ConfigurableGroup[] groups, @Nullable Configurable toSelect) {
        project2 = ShowSettingsUtilImpl.getProject(project2);
        ConfigurableGroup[] filteredGroups = ShowSettingsUtilImpl.filterEmptyGroups(groups);
        return SettingsDialogFactory.getInstance().create(project2, filteredGroups, toSelect, null);
    }

    @NotNull
    public static ConfigurableGroup[] getConfigurableGroups(@Nullable Project project2, boolean withIdeSettings) {
        if (!withIdeSettings) {
            project2 = ShowSettingsUtilImpl.getProject(project2);
        }
        return new ConfigurableGroup[]{ConfigurableExtensionPointUtil.getConfigurableGroup(project2, withIdeSettings)};
    }

    @NotNull
    public static Configurable[] getConfigurables(@Nullable Project project2, boolean withGroupReverseOrder) {
        return ShowSettingsUtilImpl.getConfigurables(ShowSettingsUtilImpl.getConfigurableGroups(project2, true), withGroupReverseOrder);
    }

    @NotNull
    private static Configurable[] getConfigurables(@NotNull ConfigurableGroup[] groups, boolean withGroupReverseOrder) {
        Configurable[][] arrays = new Configurable[groups.length][];
        int length = 0;
        for (int i2 = 0; i2 < groups.length; ++i2) {
            arrays[i2] = groups[withGroupReverseOrder ? groups.length - 1 - i2 : i2].getConfigurables();
            length += arrays[i2].length;
        }
        Configurable[] configurables = new Configurable[length];
        int offset = 0;
        for (Configurable[] array : arrays) {
            System.arraycopy(array, 0, configurables, offset, array.length);
            offset += array.length;
        }
        return configurables;
    }

    public void showSettingsDialog(@NotNull Project project2, ConfigurableGroup ... group) {
        try {
            ShowSettingsUtilImpl.getDialog(project2, group, null).show();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public void showSettingsDialog(@Nullable Project project2, Class configurableClass) {
        this.showSettingsDialog(project2, configurableClass, null);
    }

    public <T extends Configurable> void showSettingsDialog(@Nullable Project project2, @NotNull Class<T> configurableClass, @Nullable Consumer<T> additionalConfiguration) {
        assert (Configurable.class.isAssignableFrom(configurableClass)) : "Not a configurable: " + configurableClass.getName();
        ConfigurableGroup[] groups = ShowSettingsUtilImpl.getConfigurableGroups(project2, true);
        Configurable config = new ConfigurableVisitor.ByType(configurableClass).find(groups);
        assert (config != null) : "Cannot find configurable: " + configurableClass.getName();
        if (additionalConfiguration != null) {
            Configurable toConfigure = (Configurable)ConfigurableWrapper.cast(configurableClass, (UnnamedConfigurable)config);
            assert (toConfigure != null) : "Wrong configurable found: " + config.getClass();
            additionalConfiguration.accept(toConfigure);
        }
        ShowSettingsUtilImpl.getDialog(project2, groups, config).show();
    }

    public void showSettingsDialog(@Nullable Project project2, @NotNull String nameToSelect) {
        ConfigurableGroup[] groups = ShowSettingsUtilImpl.getConfigurableGroups(project2, true);
        Project actualProject = ShowSettingsUtilImpl.getProject(project2);
        groups = ShowSettingsUtilImpl.filterEmptyGroups(groups);
        ShowSettingsUtilImpl.getDialog(actualProject, groups, ShowSettingsUtilImpl.findPreselectedByDisplayName(nameToSelect, groups)).show();
    }

    @Nullable
    private static Configurable findPreselectedByDisplayName(String preselectedConfigurableDisplayName, ConfigurableGroup[] groups) {
        List<Configurable> all = SearchUtil.expand(groups);
        for (Configurable each : all) {
            if (!preselectedConfigurableDisplayName.equals(each.getDisplayName())) continue;
            return each;
        }
        return null;
    }

    public static void showSettingsDialog(@Nullable Project project2, String id2Select, String filter) {
        ConfigurableGroup[] group = ShowSettingsUtilImpl.getConfigurableGroups(project2, true);
        group = ShowSettingsUtilImpl.filterEmptyGroups(group);
        Configurable configurable2Select = id2Select == null ? null : new ConfigurableVisitor.ByID(id2Select).find(group);
        SettingsDialogFactory.getInstance().create(ShowSettingsUtilImpl.getProject(project2), group, configurable2Select, filter).show();
    }

    public void showSettingsDialog(@NotNull Project project2, Configurable toSelect) {
        ShowSettingsUtilImpl.getDialog(project2, ShowSettingsUtilImpl.getConfigurableGroups(project2, true), toSelect).show();
    }

    @NotNull
    private static ConfigurableGroup[] filterEmptyGroups(@NotNull ConfigurableGroup[] group) {
        ArrayList<ConfigurableGroup> groups = new ArrayList<ConfigurableGroup>();
        for (ConfigurableGroup g : group) {
            if (g.getConfigurables().length <= 0) continue;
            groups.add(g);
        }
        return groups.toArray(new ConfigurableGroup[groups.size()]);
    }

    public boolean editConfigurable(Project project2, Configurable configurable) {
        return this.editConfigurable(project2, ShowSettingsUtilImpl.createDimensionKey(configurable), configurable);
    }

    public <T extends Configurable> T findApplicationConfigurable(Class<T> confClass) {
        return ConfigurableExtensionPointUtil.findApplicationConfigurable(confClass);
    }

    public <T extends Configurable> T findProjectConfigurable(Project project2, Class<T> confClass) {
        return ConfigurableExtensionPointUtil.findProjectConfigurable(project2, confClass);
    }

    public boolean editConfigurable(Project project2, String dimensionServiceKey, @NotNull Configurable configurable) {
        return this.editConfigurable(project2, dimensionServiceKey, configurable, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    private static boolean isWorthToShowApplyButton(@NotNull Configurable configurable) {
        return configurable instanceof Place.Navigator || configurable instanceof Composite || configurable instanceof TabbedConfigurable;
    }

    public boolean editConfigurable(Project project2, String dimensionServiceKey, @NotNull Configurable configurable, boolean showApplyButton) {
        return ShowSettingsUtilImpl.editConfigurable(null, project2, configurable, dimensionServiceKey, null, showApplyButton);
    }

    public boolean editConfigurable(Project project2, Configurable configurable, Runnable advancedInitialization) {
        return ShowSettingsUtilImpl.editConfigurable(null, project2, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable), advancedInitialization, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull Configurable configurable) {
        return this.editConfigurable(parent, configurable, null);
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull Configurable configurable, @Nullable Runnable advancedInitialization) {
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable), advancedInitialization, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    private static boolean editConfigurable(@Nullable Component parent, @Nullable Project project2, @NotNull Configurable configurable, String dimensionKey, final @Nullable Runnable advancedInitialization, boolean showApplyButton) {
        DialogWrapper editor = parent == null ? SettingsDialogFactory.getInstance().create(project2, dimensionKey, configurable, showApplyButton, false) : SettingsDialogFactory.getInstance().create(parent, dimensionKey, configurable, showApplyButton, false);
        if (advancedInitialization != null) {
            new UiNotifyConnector.Once((Component)editor.getContentPane(), (Activatable)new Activatable.Adapter(){

                public void showNotify() {
                    advancedInitialization.run();
                }
            });
        }
        return editor.showAndGet();
    }

    @NotNull
    public static String createDimensionKey(@NotNull Configurable configurable) {
        return '#' + StringUtil.replaceChar((String)StringUtil.replaceChar((String)configurable.getDisplayName(), (char)'\n', (char)'_'), (char)' ', (char)'_');
    }

    public boolean editConfigurable(Component parent, String dimensionServiceKey, Configurable configurable) {
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable, dimensionServiceKey, null, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }
}

