/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;

public class ToggleDockModeAction
extends ToggleAction
implements DumbAware {
    public boolean isSelected(AnActionEvent event) {
        Project project2 = event.getProject();
        if (project2 == null) {
            return false;
        }
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project2);
        String id = windowManager.getActiveToolWindowId();
        if (id == null) {
            return false;
        }
        return ToolWindowType.DOCKED == windowManager.getToolWindow(id).getType();
    }

    public void setSelected(AnActionEvent event, boolean flag) {
        Project project2 = event.getProject();
        if (project2 == null) {
            return;
        }
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project2);
        String id = windowManager.getActiveToolWindowId();
        if (id == null) {
            return;
        }
        ToolWindow toolWindow = windowManager.getToolWindow(id);
        ToolWindowType type2 = toolWindow.getType();
        if (ToolWindowType.DOCKED == type2) {
            toolWindow.setType(ToolWindowType.SLIDING, null);
        } else if (ToolWindowType.SLIDING == type2) {
            toolWindow.setType(ToolWindowType.DOCKED, null);
        }
    }

    public void update(AnActionEvent event) {
        super.update(event);
        Presentation presentation = event.getPresentation();
        Project project2 = event.getProject();
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        ToolWindowManager mgr = ToolWindowManager.getInstance((Project)project2);
        String id = mgr.getActiveToolWindowId();
        if (id == null) {
            presentation.setEnabled(false);
            return;
        }
        ToolWindow toolWindow = mgr.getToolWindow(id);
        presentation.setEnabled(toolWindow.isAvailable() && toolWindow.getType() != ToolWindowType.FLOATING && toolWindow.getType() != ToolWindowType.WINDOWED);
    }
}

