/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupUtil;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.Container;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleToolbarAction
extends ToggleAction
implements DumbAware {
    private final PropertiesComponent myPropertiesComponent;
    private final String myProperty;
    private final Producer<Iterable<JComponent>> myProducer;

    @NotNull
    public static ActionGroup createToggleToolbarGroup(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
        return new DefaultActionGroup(new AnAction[]{new OptionsGroup(toolWindow), ToggleToolbarAction.createToolWindowAction(toolWindow, PropertiesComponent.getInstance((Project)project2)), Separator.getInstance()});
    }

    @NotNull
    public static ToggleToolbarAction createAction(@NotNull String id, @NotNull PropertiesComponent properties, @NotNull Producer<Iterable<JComponent>> components) {
        return new ToggleToolbarAction(properties, ToggleToolbarAction.getShowToolbarProperty(id), components);
    }

    @NotNull
    public static ToggleToolbarAction createToolWindowAction(final @NotNull ToolWindow toolWindow, final @NotNull PropertiesComponent properties) {
        toolWindow.getContentManager().addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentAdded(ContentManagerEvent event) {
                ContentManager contentManager;
                JComponent component = event.getContent().getComponent();
                ToggleToolbarAction.setToolbarVisible((Iterable<JComponent>)JBIterable.of((Object)component), ToggleToolbarAction.isToolbarVisible(toolWindow, properties));
                ContentManager contentManager2 = contentManager = component instanceof DataProvider ? (ContentManager)PlatformDataKeys.CONTENT_MANAGER.getData((DataProvider)component) : null;
                if (contentManager != null) {
                    contentManager.addContentManagerListener((ContentManagerListener)this);
                }
            }
        });
        return new ToggleToolbarAction(properties, ToggleToolbarAction.getShowToolbarProperty(toolWindow), (Producer<Iterable<JComponent>>)((Producer)() -> JBIterable.of((Object)toolWindow.getContentManager().getComponent())));
    }

    public static void setToolbarVisible(@NotNull ToolWindow toolWindow, @NotNull PropertiesComponent properties, @Nullable Boolean visible) {
        boolean state = visible == null ? ToggleToolbarAction.isToolbarVisible(toolWindow, properties) : visible;
        ToggleToolbarAction.setToolbarVisibleImpl(ToggleToolbarAction.getShowToolbarProperty(toolWindow), properties, (Iterable<JComponent>)JBIterable.of((Object)toolWindow.getComponent()), state);
    }

    public static void setToolbarVisible(@NotNull String id, @NotNull PropertiesComponent properties, @NotNull Iterable<JComponent> components, @Nullable Boolean visible) {
        boolean state = visible == null ? ToggleToolbarAction.isToolbarVisible(id, properties) : visible;
        ToggleToolbarAction.setToolbarVisibleImpl(ToggleToolbarAction.getShowToolbarProperty(id), properties, components, state);
    }

    public static void setToolbarVisible(@NotNull Iterable<JComponent> roots, boolean state) {
        for (ActionToolbar toolbar : ToggleToolbarAction.iterateToolbars(roots)) {
            JComponent c = toolbar.getComponent();
            c.setVisible(state);
            Container parent = c.getParent();
            if (!(parent instanceof EditorHeaderComponent)) continue;
            parent.setVisible(state);
        }
    }

    public static boolean isToolbarVisible(@NotNull String property, @NotNull PropertiesComponent properties) {
        return ToggleToolbarAction.isSelectedImpl(properties, ToggleToolbarAction.getShowToolbarProperty(property));
    }

    public static boolean isToolbarVisible(@NotNull ToolWindow toolWindow, @NotNull PropertiesComponent properties) {
        return ToggleToolbarAction.isSelectedImpl(properties, ToggleToolbarAction.getShowToolbarProperty(toolWindow));
    }

    private ToggleToolbarAction(@NotNull PropertiesComponent propertiesComponent, @NotNull String property, @NotNull Producer<Iterable<JComponent>> producer) {
        super("Show Toolbar");
        this.myPropertiesComponent = propertiesComponent;
        this.myProperty = property;
        this.myProducer = producer;
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        boolean hasToolbars = ToggleToolbarAction.iterateToolbars((Iterable)this.myProducer.produce()).iterator().hasNext();
        e.getPresentation().setVisible(hasToolbars);
    }

    public boolean isSelected(AnActionEvent e) {
        return this.isSelected();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        ToggleToolbarAction.setToolbarVisibleImpl(this.myProperty, this.myPropertiesComponent, (Iterable)this.myProducer.produce(), state);
    }

    static void setToolbarVisibleImpl(@NotNull String property, @NotNull PropertiesComponent propertiesComponent, @NotNull Iterable<JComponent> components, boolean visible) {
        propertiesComponent.setValue(property, String.valueOf(visible), String.valueOf(true));
        ToggleToolbarAction.setToolbarVisible(components, visible);
    }

    boolean isSelected() {
        return ToggleToolbarAction.isSelectedImpl(this.myPropertiesComponent, this.myProperty);
    }

    static boolean isSelectedImpl(@NotNull PropertiesComponent properties, @NotNull String property) {
        return properties.getBoolean(property, true);
    }

    @NotNull
    static String getShowToolbarProperty(@NotNull ToolWindow window) {
        return ToggleToolbarAction.getShowToolbarProperty("ToolWindow" + window.getStripeTitle());
    }

    @NotNull
    static String getShowToolbarProperty(@NotNull String s) {
        return s + ".ShowToolbar";
    }

    @NotNull
    private static Iterable<ActionToolbar> iterateToolbars(Iterable<JComponent> roots) {
        return ((JBTreeTraverser)UIUtil.uiTraverser(null).withRoots(roots)).preOrderDfsTraversal().filter(ActionToolbar.class);
    }

    private static class OptionsGroup
    extends ActionGroup
    implements DumbAware {
        private final ToolWindow myToolWindow;

        public OptionsGroup(ToolWindow toolWindow) {
            super("View Options", true);
            this.myToolWindow = toolWindow;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setVisible(!ActionGroupUtil.isGroupEmpty((ActionGroup)this, (AnActionEvent)e, (boolean)LaterInvocator.isInModalContext()));
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            JComponent contentComponent;
            ContentManager contentManager = this.myToolWindow.getContentManager();
            Content selectedContent = contentManager.getSelectedContent();
            JComponent jComponent = contentComponent = selectedContent != null ? selectedContent.getComponent() : null;
            if (contentComponent == null) {
                return EMPTY_ARRAY;
            }
            List result2 = ContainerUtil.newSmartList();
            for (ActionToolbar toolbar : ToggleToolbarAction.iterateToolbars((Iterable)JBIterable.of((Object)contentComponent))) {
                JComponent c = toolbar.getComponent();
                if (c.isVisible() || !c.isValid()) continue;
                if (!result2.isEmpty() && !(ContainerUtil.getLastItem((List)result2) instanceof Separator)) {
                    result2.add(Separator.getInstance());
                }
                List actions = toolbar.getActions();
                for (AnAction action : actions) {
                    if (action instanceof ToggleAction && !result2.contains(action)) {
                        result2.add(action);
                        continue;
                    }
                    if (!(action instanceof Separator) || result2.isEmpty() || ContainerUtil.getLastItem((List)result2) instanceof Separator) continue;
                    result2.add(Separator.getInstance());
                }
            }
            boolean popup = result2.size() > 3;
            this.setPopup(popup);
            if (!popup && !result2.isEmpty()) {
                result2.add(Separator.getInstance());
            }
            return result2.toArray(new AnAction[result2.size()]);
        }
    }
}

