/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkItem;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.favoritesTreeView.AbstractFavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BookmarksFavoriteListProvider
extends AbstractFavoritesListProvider<Bookmark>
implements BookmarksListener {
    private final BookmarkManager myBookmarkManager;
    private final FavoritesManager myFavoritesManager;

    public BookmarksFavoriteListProvider(Project project2, BookmarkManager bookmarkManager, FavoritesManager favoritesManager) {
        super(project2, "Bookmarks");
        this.myBookmarkManager = bookmarkManager;
        this.myFavoritesManager = favoritesManager;
        project2.getMessageBus().connect((Disposable)project2).subscribe(BookmarksListener.TOPIC, (Object)this);
        this.updateChildren();
    }

    @Override
    public void bookmarkAdded(@NotNull Bookmark b) {
        this.updateChildren();
    }

    @Override
    public void bookmarkRemoved(@NotNull Bookmark b) {
        this.updateChildren();
    }

    @Override
    public void bookmarkChanged(@NotNull Bookmark b) {
        this.updateChildren();
    }

    @Override
    public void bookmarksOrderChanged() {
        this.updateChildren();
    }

    @Override
    public String getListName(Project project2) {
        return "Bookmarks";
    }

    private void updateChildren() {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myChildren.clear();
        List<Bookmark> bookmarks = this.myBookmarkManager.getValidBookmarks();
        for (final Bookmark bookmark : bookmarks) {
            AbstractTreeNode<Bookmark> child = new AbstractTreeNode<Bookmark>(this.myProject, bookmark){

                @NotNull
                public Collection<? extends AbstractTreeNode> getChildren() {
                    return Collections.emptyList();
                }

                public boolean canNavigate() {
                    return bookmark.canNavigate();
                }

                public boolean canNavigateToSource() {
                    return bookmark.canNavigateToSource();
                }

                public void navigate(boolean requestFocus) {
                    bookmark.navigate(requestFocus);
                }

                protected void update(PresentationData presentation) {
                    presentation.setPresentableText(bookmark.toString());
                    presentation.setIcon(bookmark.getIcon());
                }
            };
            child.setParent((AbstractTreeNode)this.myNode);
            this.myChildren.add(child);
        }
        this.myFavoritesManager.fireListeners(this.getListName(this.myProject));
    }

    @Override
    @Nullable
    public String getCustomName(@NotNull CommonActionsPanel.Buttons type2) {
        switch (type2) {
            case EDIT: {
                return IdeBundle.message((String)"action.bookmark.edit.description", (Object[])new Object[0]);
            }
            case REMOVE: {
                return IdeBundle.message((String)"action.bookmark.delete", (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    public boolean willHandle(@NotNull CommonActionsPanel.Buttons type2, Project project2, @NotNull Set<Object> selectedObjects) {
        switch (type2) {
            case EDIT: {
                if (selectedObjects.size() != 1) {
                    return false;
                }
                Object toEdit = selectedObjects.iterator().next();
                return toEdit instanceof AbstractTreeNode && ((AbstractTreeNode)toEdit).getValue() instanceof Bookmark;
            }
            case REMOVE: {
                for (Object toRemove : selectedObjects) {
                    if (toRemove instanceof AbstractTreeNode && ((AbstractTreeNode)toRemove).getValue() instanceof Bookmark) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void handle(@NotNull CommonActionsPanel.Buttons type2, Project project2, @NotNull Set<Object> selectedObjects, JComponent component) {
        switch (type2) {
            case EDIT: {
                if (selectedObjects.size() != 1) {
                    return;
                }
                Object toEdit = selectedObjects.iterator().next();
                if (toEdit instanceof AbstractTreeNode && ((AbstractTreeNode)toEdit).getValue() instanceof Bookmark) {
                    Bookmark bookmark = (Bookmark)((AbstractTreeNode)toEdit).getValue();
                    if (bookmark == null) {
                        return;
                    }
                    BookmarkManager.getInstance(project2).editDescription(bookmark);
                }
                return;
            }
            case REMOVE: {
                for (Object toRemove : selectedObjects) {
                    Bookmark bookmark = (Bookmark)((AbstractTreeNode)toRemove).getValue();
                    BookmarkManager.getInstance(project2).removeBookmark(bookmark);
                }
                return;
            }
        }
    }

    @Override
    public int getWeight() {
        return 100;
    }

    @Override
    public void customizeRenderer(ColoredTreeCellRenderer renderer, JTree tree, @NotNull Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        renderer.clear();
        renderer.setIcon(Bookmark.DEFAULT_ICON);
        if (value2 instanceof Bookmark) {
            Bookmark bookmark = (Bookmark)value2;
            BookmarkItem.setupRenderer((SimpleColoredComponent)renderer, this.myProject, bookmark, selected);
            if (renderer.getIcon() != null) {
                RowIcon icon = new RowIcon(3, RowIcon.Alignment.CENTER);
                icon.setIcon(bookmark.getIcon(), 0);
                icon.setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)1)), 1);
                icon.setIcon(renderer.getIcon(), 2);
                renderer.setIcon((Icon)icon);
            } else {
                renderer.setIcon(bookmark.getIcon());
            }
        } else {
            renderer.append(this.getListName(this.myProject));
        }
    }
}

