/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkItem;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.bookmarks.actions.DeleteBookmarkAction;
import com.intellij.ide.bookmarks.actions.EditBookmarkDescriptionAction;
import com.intellij.ide.bookmarks.actions.MoveBookmarkDownAction;
import com.intellij.ide.bookmarks.actions.MoveBookmarkUpAction;
import com.intellij.ide.bookmarks.actions.ToggleSortBookmarksAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.util.DetailViewImpl;
import com.intellij.ui.popup.util.ItemWrapper;
import com.intellij.ui.popup.util.MasterDetailPopupBuilder;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BookmarksAction
extends AnAction
implements DumbAware,
MasterDetailPopupBuilder.Delegate {
    @NonNls
    private static final String DIMENSION_SERVICE_KEY = "bookmarks";
    private JBPopup myPopup;

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        final Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        if (this.myPopup != null && this.myPopup.isVisible()) {
            this.myPopup.cancel();
            return;
        }
        final JBList list = new JBList((ListModel)BookmarksAction.buildModel(project2));
        EditBookmarkDescriptionAction editDescriptionAction = new EditBookmarkDescriptionAction(project2, (JList)list);
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)editDescriptionAction);
        actions.add((AnAction)new DeleteBookmarkAction(project2, (JList)list));
        actions.add((AnAction)new ToggleSortBookmarksAction());
        actions.add((AnAction)new MoveBookmarkUpAction(project2, (JList)list));
        actions.add((AnAction)new MoveBookmarkDownAction(project2, (JList)list));
        this.myPopup = new MasterDetailPopupBuilder(project2).setList(list).setDelegate(this).setDetailView(new DetailViewImpl(project2)).setDimensionServiceKey(DIMENSION_SERVICE_KEY).setAddDetailViewToEast(true).setActionsGroup((ActionGroup)actions).setPopupTuner((Consumer<PopupChooserBuilder>)((Consumer)builder -> builder.setCloseOnEnter(false).setCancelOnClickOutside(false))).setDoneRunnable(() -> this.myPopup.cancel()).createMasterDetailPopup();
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                Object[] values;
                for (Object item : values = list.getSelectedValues()) {
                    if (!(item instanceof BookmarkItem)) continue;
                    BookmarksAction.this.itemChosen((BookmarkItem)item, project2, BookmarksAction.this.myPopup, true);
                }
            }
        }.registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)list);
        editDescriptionAction.setPopup(this.myPopup);
        Point location = DimensionService.getInstance().getLocation(DIMENSION_SERVICE_KEY, project2);
        if (location != null) {
            this.myPopup.showInScreenCoordinates((Component)WindowManager.getInstance().getFrame(project2), location);
        } else {
            this.myPopup.showCenteredInCurrentWindow(project2);
        }
        list.getEmptyText().setText("No Bookmarks");
        list.setSelectionMode(2);
        project2.getMessageBus().connect((Disposable)this.myPopup).subscribe(BookmarksListener.TOPIC, (Object)new BookmarksListener(){

            @Override
            public void bookmarkAdded(@NotNull Bookmark b) {
            }

            @Override
            public void bookmarkRemoved(@NotNull Bookmark b) {
            }

            @Override
            public void bookmarkChanged(@NotNull Bookmark b) {
            }

            @Override
            public void bookmarksOrderChanged() {
                this.doUpdate();
            }

            private void doUpdate() {
                TreeSet<Object> selectedValues = new TreeSet<Object>(Arrays.asList(list.getSelectedValues()));
                DefaultListModel listModel = BookmarksAction.buildModel(project2);
                list.setModel((ListModel)listModel);
                ListSelectionModel selectionModel = list.getSelectionModel();
                for (int i = 0; i < listModel.getSize(); ++i) {
                    if (!selectedValues.contains(listModel.get(i))) continue;
                    selectionModel.addSelectionInterval(i, i);
                }
            }
        });
    }

    private static DefaultListModel buildModel(Project project2) {
        DefaultListModel<BookmarkItem> model = new DefaultListModel<BookmarkItem>();
        for (Bookmark bookmark : BookmarkManager.getInstance(project2).getValidBookmarks()) {
            model.addElement(new BookmarkItem(bookmark));
        }
        return model;
    }

    @Override
    public String getTitle() {
        return "Bookmarks";
    }

    @Override
    public void handleMnemonic(KeyEvent e, Project project2, JBPopup popup) {
        char mnemonic = e.getKeyChar();
        Bookmark bookmark = BookmarkManager.getInstance(project2).findBookmarkForMnemonic(mnemonic);
        if (bookmark != null) {
            popup.cancel();
            IdeFocusManager.getInstance((Project)project2).doWhenFocusSettlesDown(() -> bookmark.navigate(true));
        }
    }

    @Override
    @Nullable
    public JComponent createAccessoryView(Project project2) {
        if (!BookmarkManager.getInstance(project2).hasBookmarksWithMnemonics()) {
            return null;
        }
        JLabel mnemonicLabel = new JLabel();
        mnemonicLabel.setFont(Bookmark.getBookmarkFont());
        mnemonicLabel.setPreferredSize(new JLabel("W.").getPreferredSize());
        mnemonicLabel.setOpaque(false);
        return mnemonicLabel;
    }

    @Override
    public Object[] getSelectedItemsInTree() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public void itemChosen(ItemWrapper item, Project project2, JBPopup popup, boolean withEnterOrDoubleClick) {
        if (item instanceof BookmarkItem && withEnterOrDoubleClick) {
            Bookmark bookmark = ((BookmarkItem)item).getBookmark();
            popup.cancel();
            bookmark.navigate(true);
        }
    }

    @Override
    public void removeSelectedItemsInTree() {
    }

    static List<Bookmark> getSelectedBookmarks(JList list) {
        ArrayList<Bookmark> answer = new ArrayList<Bookmark>();
        for (Object value2 : list.getSelectedValues()) {
            if (!(value2 instanceof BookmarkItem)) {
                return Collections.emptyList();
            }
            answer.add(((BookmarkItem)value2).getBookmark());
        }
        return answer;
    }

    static boolean notFiltered(JList list) {
        ListModel model1 = list.getModel();
        if (!(model1 instanceof FilteringListModel)) {
            return true;
        }
        FilteringListModel model = (FilteringListModel)model1;
        return model.getOriginalModel().getSize() == model.getSize();
    }

    protected static class BookmarkInContextInfo {
        private final DataContext myDataContext;
        private final Project myProject;
        private Bookmark myBookmarkAtPlace;
        private VirtualFile myFile;
        private int myLine;

        public BookmarkInContextInfo(DataContext dataContext, Project project2) {
            this.myDataContext = dataContext;
            this.myProject = project2;
        }

        public Bookmark getBookmarkAtPlace() {
            return this.myBookmarkAtPlace;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public int getLine() {
            return this.myLine;
        }

        public BookmarkInContextInfo invoke() {
            this.myBookmarkAtPlace = null;
            this.myFile = null;
            this.myLine = -1;
            BookmarkManager bookmarkManager = BookmarkManager.getInstance(this.myProject);
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(this.myDataContext);
            if (editor != null) {
                if (ToolWindowManager.getInstance((Project)this.myProject).isEditorComponentActive()) {
                    Document document = editor.getDocument();
                    this.myLine = editor.getCaretModel().getLogicalPosition().line;
                    this.myFile = FileDocumentManager.getInstance().getFile(document);
                    this.myBookmarkAtPlace = bookmarkManager.findEditorBookmark(document, this.myLine);
                } else {
                    this.myFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(this.myDataContext);
                    if (this.myFile != null) {
                        Document document = editor.getDocument();
                        if (Comparing.equal((Object)this.myFile, (Object)FileDocumentManager.getInstance().getFile(document))) {
                            this.myLine = editor.getCaretModel().getLogicalPosition().line;
                            this.myBookmarkAtPlace = bookmarkManager.findEditorBookmark(document, this.myLine);
                        }
                    }
                }
            }
            if (this.myFile == null) {
                this.myFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(this.myDataContext);
                this.myLine = -1;
                if (this.myBookmarkAtPlace == null && this.myFile != null) {
                    this.myBookmarkAtPlace = bookmarkManager.findFileBookmark(this.myFile);
                }
            }
            return this;
        }
    }
}

