/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.google.common.base.CharMatcher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserReferenceConverter;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="browser")
public class StartBrowserSettings {
    private boolean mySelected;
    private WebBrowser myBrowser;
    private String myUrl;
    private boolean myStartJavaScriptDebugger;

    @Attribute(value="start")
    public boolean isSelected() {
        return this.mySelected;
    }

    public void setSelected(boolean selected) {
        this.mySelected = selected;
    }

    @Attribute(value="name", converter=WebBrowserReferenceConverter.class)
    @Nullable
    public WebBrowser getBrowser() {
        return this.myBrowser;
    }

    public void setBrowser(@Nullable WebBrowser value2) {
        this.myBrowser = value2;
    }

    @Attribute
    @Nullable
    public String getUrl() {
        return this.myUrl;
    }

    public void setUrl(@Nullable String value2) {
        String normalized = StringUtil.nullize((String)value2, (boolean)true);
        if (normalized != null) {
            normalized = CharMatcher.WHITESPACE.trimFrom((CharSequence)normalized);
        }
        this.myUrl = normalized;
    }

    @Attribute(value="with-js-debugger")
    public boolean isStartJavaScriptDebugger() {
        return this.myStartJavaScriptDebugger;
    }

    public void setStartJavaScriptDebugger(boolean value2) {
        this.myStartJavaScriptDebugger = value2;
    }

    @NotNull
    public static StartBrowserSettings readExternal(@NotNull Element parent) {
        Element state = parent.getChild("browser");
        StartBrowserSettings settings = new StartBrowserSettings();
        if (state != null) {
            XmlSerializer.deserializeInto((Object)settings, (Element)state);
        }
        return settings;
    }

    public void writeExternal(@NotNull Element parent) {
        Element state = XmlSerializer.serialize((Object)this, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        if (!JDOMUtil.isEmpty((Element)state)) {
            parent.addContent(state);
        }
    }
}

