/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.impl;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.OpenInBrowserRequestKt;
import com.intellij.ide.browsers.WebBrowserService;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.ide.browsers.impl.WebBrowserServiceImplKt;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/browsers/impl/WebBrowserServiceImpl;", "Lcom/intellij/ide/browsers/WebBrowserService;", "()V", "getUrlsToOpen", "", "Lcom/intellij/util/Url;", "request", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "preferLocalUrl", "", "Companion", "xml"})
public final class WebBrowserServiceImpl
extends WebBrowserService {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Collection<Url> getUrlsToOpen(@NotNull OpenInBrowserRequest request, boolean preferLocalUrl) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        boolean isHtmlOrXml = WebBrowserService.isHtmlOrXmlFile((Language)request.getFile().getViewProvider().getBaseLanguage());
        if (!preferLocalUrl || !isHtmlOrXml) {
            DumbService dumbService = DumbService.getInstance((Project)request.getProject());
            WebBrowserUrlProvider[] webBrowserUrlProviderArray = (WebBrowserUrlProvider[])WebBrowserUrlProvider.Companion.getEP_NAME().getExtensions();
            for (int j = 0; j < webBrowserUrlProviderArray.length; ++j) {
                Collection urls;
                WebBrowserUrlProvider urlProvider = webBrowserUrlProviderArray[j];
                if (dumbService.isDumb() && !DumbService.isDumbAware((Object)urlProvider) || !urlProvider.canHandleElement(request) || (urls = WebBrowserServiceImplKt.access$getUrls(urlProvider, request)).isEmpty()) continue;
                return urls;
            }
            if (!isHtmlOrXml) {
                return CollectionsKt.emptyList();
            }
        }
        VirtualFile file2 = !request.getFile().getViewProvider().isPhysical() ? null : request.getVirtualFile();
        return file2 instanceof LightVirtualFile || file2 == null ? (Collection)CollectionsKt.emptyList() : (Collection)CollectionsKt.listOf((Object)Urls.newFromVirtualFile(file2));
    }

    @JvmStatic
    @Nullable
    public static final Url getDebuggableUrl(@Nullable PsiElement context) {
        return Companion.getDebuggableUrl(context);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/browsers/impl/WebBrowserServiceImpl$Companion;", "", "()V", "getDebuggableUrl", "Lcom/intellij/util/Url;", "Lorg/jetbrains/annotations/Nullable;", "context", "Lcom/intellij/psi/PsiElement;", "getDebuggableUrls", "", "getProvider", "Lcom/intellij/ide/browsers/WebBrowserUrlProvider;", "request", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "xml"})
    public static final class Companion {
        @Nullable
        public final WebBrowserUrlProvider getProvider(@NotNull OpenInBrowserRequest request) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            DumbService dumbService = DumbService.getInstance((Project)request.getProject());
            WebBrowserUrlProvider[] webBrowserUrlProviderArray = (WebBrowserUrlProvider[])WebBrowserUrlProvider.Companion.getEP_NAME().getExtensions();
            for (int j = 0; j < webBrowserUrlProviderArray.length; ++j) {
                WebBrowserUrlProvider urlProvider = webBrowserUrlProviderArray[j];
                if (dumbService.isDumb() && !DumbService.isDumbAware((Object)urlProvider) || !urlProvider.canHandleElement(request)) continue;
                return urlProvider;
            }
            return null;
        }

        @NotNull
        public final Collection<Url> getDebuggableUrls(@Nullable PsiElement context) {
            try {
                OpenInBrowserRequest request;
                OpenInBrowserRequest openInBrowserRequest = request = context == null ? null : OpenInBrowserRequestKt.createOpenInBrowserRequest((PsiElement)context);
                if (request == null || request.getFile().getViewProvider().getBaseLanguage() == XMLLanguage.INSTANCE) {
                    return CollectionsKt.emptyList();
                }
                request.setAppendAccessToken(false);
                return WebBrowserServiceImplKt.access$getUrls(this.getProvider(request), request);
            }
            catch (WebBrowserUrlProvider.BrowserException ignored) {
                return CollectionsKt.emptyList();
            }
        }

        @JvmStatic
        @Nullable
        public final Url getDebuggableUrl(@Nullable PsiElement context) {
            return (Url)ContainerUtil.getFirstItem(this.getDebuggableUrls(context));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

