/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ide.customize.CustomizeIDEWizardDialog;
import com.intellij.ide.customize.IdSet;
import com.intellij.ide.customize.PluginGroups;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.internal.statistic.ideSettings.IdeInitialConfigButtonUsages;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class CustomizePluginsStepPanel
extends AbstractCustomizeWizardStep
implements LinkListener<String> {
    private static final String MAIN = "main";
    private static final String CUSTOMIZE = "customize";
    private static final int COLS = 3;
    private static final TextProvider CUSTOMIZE_TEXT_PROVIDER = new TextProvider(){

        @Override
        public String getText() {
            return "Customize...";
        }
    };
    private static final String SWITCH_COMMAND = "Switch";
    private static final String CUSTOMIZE_COMMAND = "Customize";
    private final JBCardLayout myCardLayout;
    private final IdSetPanel myCustomizePanel;
    private final PluginGroups myPluginGroups;

    public CustomizePluginsStepPanel(PluginGroups pluginGroups) {
        this.myPluginGroups = pluginGroups;
        this.myCardLayout = new JBCardLayout();
        this.setLayout((LayoutManager)this.myCardLayout);
        JPanel gridPanel = new JPanel(new GridLayout(0, 3));
        this.myCustomizePanel = new IdSetPanel();
        JBScrollPane scrollPane = CustomizePluginsStepPanel.createScrollPane(gridPanel);
        this.add((Component)scrollPane, MAIN);
        this.add((Component)this.myCustomizePanel, CUSTOMIZE);
        Map<String, Pair<Icon, List<String>>> groups = pluginGroups.getTree();
        for (Map.Entry<String, Pair<Icon, List<String>>> entry : groups.entrySet()) {
            final String group = entry.getKey();
            if ("Core".equals(group) || this.myPluginGroups.getSets(group).isEmpty()) continue;
            JPanel groupPanel = new JPanel(new GridBagLayout()){

                @Override
                public Color getBackground() {
                    Color color = UIManager.getColor("Panel.background");
                    return CustomizePluginsStepPanel.this.isGroupEnabled(group) ? color : ColorUtil.darker((Color)color, (int)1);
                }
            };
            gridPanel.setOpaque(true);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            JLabel titleLabel = new JLabel("<html><body><h2 style=\"text-align:center;\">" + group + "</h2></body></html>", 0){

                @Override
                public boolean isEnabled() {
                    return CustomizePluginsStepPanel.this.isGroupEnabled(group);
                }
            };
            groupPanel.add((Component)new JLabel((Icon)entry.getValue().getFirst()), gbc);
            groupPanel.add((Component)titleLabel, gbc);
            JLabel descriptionLabel = new JLabel(pluginGroups.getDescription(group), 0){

                @Override
                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    size.width = Math.min(size.width, 200);
                    return size;
                }

                @Override
                public boolean isEnabled() {
                    return CustomizePluginsStepPanel.this.isGroupEnabled(group);
                }

                @Override
                public Color getForeground() {
                    return ColorUtil.withAlpha((Color)UIManager.getColor("Label.foreground"), (double)0.75);
                }
            };
            groupPanel.add((Component)descriptionLabel, gbc);
            gbc.weighty = 1.0;
            groupPanel.add(Box.createVerticalGlue(), gbc);
            gbc.weighty = 0.0;
            JPanel buttonsPanel = new JPanel(new FlowLayout(1, 10, 5));
            buttonsPanel.setOpaque(false);
            if (pluginGroups.getSets(group).size() == 1) {
                buttonsPanel.add((Component)this.createLink("Switch:" + group, this.getGroupSwitchTextProvider(group)));
            } else {
                buttonsPanel.add((Component)this.createLink("Customize:" + group, CUSTOMIZE_TEXT_PROVIDER));
                buttonsPanel.add((Component)this.createLink("Switch:" + group, this.getGroupSwitchTextProvider(group)));
            }
            groupPanel.add((Component)buttonsPanel, gbc);
            gridPanel.add(groupPanel);
        }
        int cursor = 0;
        Component[] components = gridPanel.getComponents();
        int rowCount = components.length / 3;
        if (components.length % 3 == 0) {
            --rowCount;
        }
        for (Component component : components) {
            ((JComponent)component).setBorder(new CompoundBorder((Border)new CustomLineBorder(ColorUtil.withAlpha((Color)JBColor.foreground(), (double)0.2), 0, 0, cursor / 3 <= rowCount - 1 ? 1 : 0, cursor % 3 != 2 ? 1 : 0){

                protected Color getColor() {
                    return ColorUtil.withAlpha((Color)JBColor.foreground(), (double)0.2);
                }
            }, BorderFactory.createEmptyBorder(10, 20, 10, 20)));
            ++cursor;
        }
    }

    static JBScrollPane createScrollPane(JPanel gridPanel) {
        JBScrollPane scrollPane = new JBScrollPane((Component)gridPanel, 20, 31);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        return scrollPane;
    }

    public void linkSelected(LinkLabel linkLabel, String command) {
        if (command == null || !command.contains(":")) {
            return;
        }
        int semicolonPosition = command.indexOf(":");
        String group = command.substring(semicolonPosition + 1);
        if (SWITCH_COMMAND.equals(command = command.substring(0, semicolonPosition))) {
            boolean enabled = this.isGroupEnabled(group);
            List<IdSet> sets = this.myPluginGroups.getSets(group);
            for (IdSet idSet : sets) {
                String[] ids;
                for (String id : ids = idSet.getIds()) {
                    this.myPluginGroups.setPluginEnabledWithDependencies(id, !enabled);
                }
            }
            this.repaint();
            return;
        }
        if (CUSTOMIZE_COMMAND.equals(command)) {
            this.myCustomizePanel.update(group);
            this.myCardLayout.show((Container)this, CUSTOMIZE);
            this.setButtonsVisible(false);
        }
    }

    private void setButtonsVisible(boolean visible) {
        DialogWrapper window = DialogWrapper.findInstance((Component)this);
        if (window instanceof CustomizeIDEWizardDialog) {
            ((CustomizeIDEWizardDialog)window).setButtonsVisible(visible);
        }
    }

    private LinkLabel createLink(String command, final TextProvider provider2) {
        return new LinkLabel<String>("", null, (LinkListener)this, command){

            public String getText() {
                return provider2.getText();
            }
        };
    }

    TextProvider getGroupSwitchTextProvider(final String group) {
        return new TextProvider(){

            @Override
            public String getText() {
                return (CustomizePluginsStepPanel.this.isGroupEnabled(group) ? "Disable" : "Enable") + (CustomizePluginsStepPanel.this.myPluginGroups.getSets(group).size() > 1 ? " All" : "");
            }
        };
    }

    private boolean isGroupEnabled(String group) {
        List<IdSet> sets = this.myPluginGroups.getSets(group);
        for (IdSet idSet : sets) {
            String[] ids;
            for (String id : ids = idSet.getIds()) {
                if (!this.myPluginGroups.isPluginEnabled(id)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getTitle() {
        return "Default plugins";
    }

    @Override
    public String getHTMLHeader() {
        return "<html><body><h2>Tune " + ApplicationNamesInfo.getInstance().getProductName() + " to your tasks</h2>" + ApplicationNamesInfo.getInstance().getProductName() + " has a lot of tools enabled by default. You can set only ones you need or leave them all.</body></html>";
    }

    @Override
    public boolean beforeOkAction() {
        try {
            PluginManager.saveDisabledPlugins(this.myPluginGroups.getDisabledPluginIds(), false);
            IdeInitialConfigButtonUsages.setPredefinedDisabledPlugins(new HashSet<String>(this.myPluginGroups.getDisabledPluginIds()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private static interface TextProvider {
        public String getText();
    }

    private class IdSetPanel
    extends JPanel
    implements LinkListener<String> {
        private JLabel myTitleLabel = new JLabel();
        private JPanel myContentPanel = new JPanel(new GridLayout(0, 3, 5, 5));
        private JButton mySaveButton = new JButton("Save Changes and Go Back");
        private String myGroup;

        private IdSetPanel() {
            this.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 20, true, false));
            this.add(this.myTitleLabel);
            this.add(this.myContentPanel);
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets.right = 25;
            gbc.gridy = 0;
            buttonPanel.add((Component)this.mySaveButton, gbc);
            buttonPanel.add((Component)new LinkLabel("Enable All", null, (LinkListener)this, (Object)"enable"), gbc);
            buttonPanel.add((Component)new LinkLabel("Disable All", null, (LinkListener)this, (Object)"disable"), gbc);
            gbc.weightx = 1.0;
            buttonPanel.add(Box.createHorizontalGlue(), gbc);
            this.add(buttonPanel);
            this.mySaveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomizePluginsStepPanel.this.myCardLayout.show((Container)CustomizePluginsStepPanel.this, CustomizePluginsStepPanel.MAIN);
                    CustomizePluginsStepPanel.this.setButtonsVisible(true);
                }
            });
        }

        public void linkSelected(LinkLabel aSource, String command) {
            if (this.myGroup == null) {
                return;
            }
            boolean enable = "enable".equals(command);
            List<IdSet> idSets = CustomizePluginsStepPanel.this.myPluginGroups.getSets(this.myGroup);
            for (IdSet set2 : idSets) {
                CustomizePluginsStepPanel.this.myPluginGroups.setIdSetEnabled(set2, enable);
            }
            CustomizePluginsStepPanel.this.repaint();
        }

        void update(String group) {
            this.myGroup = group;
            this.myTitleLabel.setText("<html><body><h2 style=\"text-align:left;\">" + group + "</h2></body></html>");
            this.myContentPanel.removeAll();
            List<IdSet> idSets = CustomizePluginsStepPanel.this.myPluginGroups.getSets(group);
            for (final IdSet set2 : idSets) {
                final JCheckBox checkBox = new JCheckBox(set2.getTitle(), CustomizePluginsStepPanel.this.myPluginGroups.isIdSetAllEnabled(set2));
                checkBox.setModel(new JToggleButton.ToggleButtonModel(){

                    @Override
                    public boolean isSelected() {
                        return CustomizePluginsStepPanel.this.myPluginGroups.isIdSetAllEnabled(set2);
                    }
                });
                checkBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CustomizePluginsStepPanel.this.myPluginGroups.setIdSetEnabled(set2, !checkBox.isSelected());
                        CustomizePluginsStepPanel.this.repaint();
                    }
                });
                this.myContentPanel.add(checkBox);
            }
        }
    }
}

