/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.diff;

import com.intellij.ide.diff.VirtualFileDiffElement;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class JarFileDiffElement
extends VirtualFileDiffElement {
    public JarFileDiffElement(@NotNull VirtualFile file2) {
        super(file2.getFileSystem() == JarFileSystem.getInstance() ? file2 : JarFileSystem.getInstance().getJarRootForLocalFile(file2));
    }

    @Override
    protected VirtualFileDiffElement createElement(VirtualFile file2) {
        VirtualFile jar = JarFileSystem.getInstance().getJarRootForLocalFile(file2);
        return jar == null ? null : new JarFileDiffElement(file2);
    }

    @Override
    protected FileChooserDescriptor getChooserDescriptor() {
        return new FileChooserDescriptor(true, false, true, true, false, false){

            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                return file2.isDirectory() || !file2.isDirectory() && "jar".equalsIgnoreCase(file2.getExtension());
            }
        };
    }
}

