/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd.aware;

import com.intellij.ide.dnd.DnDAware;
import com.intellij.ide.dnd.TransferableList;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DnDAwareTree
extends Tree
implements DnDAware {
    private static final TransferHandler DEFAULT_TRANSFER_HANDLER = new TransferHandler(){

        @Override
        protected Transferable createTransferable(JComponent component) {
            JTree tree;
            TreePath[] selection;
            if (component instanceof JTree && (selection = (tree = (JTree)component).getSelectionPaths()) != null && selection.length > 1) {
                return new TransferableList<TreePath>(selection){

                    @Override
                    protected String toString(TreePath path) {
                        return String.valueOf(path.getLastPathComponent());
                    }
                };
            }
            return null;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }
    };

    public DnDAwareTree() {
        this.initDnD();
    }

    public DnDAwareTree(TreeModel treemodel) {
        super(treemodel);
        this.initDnD();
    }

    public DnDAwareTree(TreeNode root) {
        super(root);
        this.initDnD();
    }

    public void processMouseEvent(MouseEvent e) {
        if (this.getToolTipText() == null && e.getID() == 504) {
            return;
        }
        super.processMouseEvent(e);
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        if (SystemInfo.isMac && JBSwingUtilities.isRightMouseButton((MouseEvent)e) && e.getID() == 506) {
            return;
        }
        super.processMouseMotionEvent(e);
    }

    public final boolean isOverSelection(Point point) {
        TreePath path;
        TreePath treePath = path = WideSelectionTreeUI.isWideSelection((JTree)((Object)this)) ? this.getClosestPathForLocation(point.x, point.y) : this.getPathForLocation(point.x, point.y);
        if (path == null) {
            return false;
        }
        return this.isPathSelected(path);
    }

    public void dropSelectionButUnderPoint(Point point) {
        TreeUtil.dropSelectionButUnderPoint((JTree)((Object)this), (Point)point);
    }

    @NotNull
    public final JComponent getComponent() {
        return this;
    }

    @NotNull
    public static Pair<Image, Point> getDragImage(@NotNull Tree dndAwareTree, @NotNull TreePath path, @NotNull Point dragOrigin) {
        int row = dndAwareTree.getRowForPath(path);
        Component comp = dndAwareTree.getCellRenderer().getTreeCellRendererComponent((JTree)dndAwareTree, path.getLastPathComponent(), false, true, true, row, false);
        return DnDAwareTree.createDragImage(dndAwareTree, comp, dragOrigin, true);
    }

    @NotNull
    public static Pair<Image, Point> getDragImage(@NotNull Tree dndAwareTree, @NotNull String text, @Nullable Point dragOrigin) {
        return DnDAwareTree.createDragImage(dndAwareTree, new JLabel(text), dragOrigin, false);
    }

    @NotNull
    private static Pair<Image, Point> createDragImage(@NotNull Tree tree, @NotNull Component c, @Nullable Point dragOrigin, boolean adjustToPathUnderDragOrigin) {
        TreePath path;
        if (c instanceof JComponent) {
            ((JComponent)c).setOpaque(true);
        }
        c.setForeground(tree.getForeground());
        c.setBackground(tree.getBackground());
        c.setFont(tree.getFont());
        c.setSize(c.getPreferredSize());
        BufferedImage image = UIUtil.createImage((Component)c, (int)c.getWidth(), (int)c.getHeight(), (int)2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
        c.paint(g2);
        g2.dispose();
        Point point = new Point(image.getWidth(null) / 2, image.getHeight(null) / 2);
        if (adjustToPathUnderDragOrigin && (path = tree.getPathForLocation(dragOrigin.x, dragOrigin.y)) != null) {
            Rectangle bounds = tree.getPathBounds(path);
            point = new Point(dragOrigin.x - bounds.x, dragOrigin.y - bounds.y);
        }
        return new Pair((Object)image, (Object)point);
    }

    private void initDnD() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.setDragEnabled(true);
            this.setTransferHandler(DEFAULT_TRANSFER_HANDLER);
        }
    }
}

