/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView.impl;

import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.util.SystemProperties;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TooManyListenersException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class ErrorViewTextExporter
implements ExporterToTextFile {
    private final JCheckBox myCbShowDetails;
    private final ErrorViewStructure myStructure;
    private ChangeListener myChangeListener;

    public ErrorViewTextExporter(ErrorViewStructure treeStructure) {
        this.myStructure = treeStructure;
        this.myCbShowDetails = new JCheckBox(IdeBundle.message((String)"checkbox.errortree.export.details", (Object[])new Object[0]));
        this.myCbShowDetails.setSelected(true);
        this.myCbShowDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorViewTextExporter.this.myChangeListener.stateChanged(null);
            }
        });
    }

    public JComponent getSettingsEditor() {
        return this.myCbShowDetails;
    }

    public void addSettingsChangedListener(ChangeListener listener2) throws TooManyListenersException {
        if (this.myChangeListener != null) {
            throw new TooManyListenersException();
        }
        this.myChangeListener = listener2;
    }

    public void removeSettingsChangedListener(ChangeListener listener2) {
        this.myChangeListener = null;
    }

    @NotNull
    public String getReportText() {
        StringBuffer buffer = new StringBuffer();
        this.getReportText(buffer, (ErrorTreeElement)this.myStructure.getRootElement(), this.myCbShowDetails.isSelected(), 0);
        return buffer.toString();
    }

    @NotNull
    public String getDefaultFilePath() {
        return "";
    }

    public void exportedTo(String filePath) {
    }

    public boolean canExport() {
        return true;
    }

    private void getReportText(StringBuffer buffer, ErrorTreeElement element, boolean withUsages, int indent) {
        ErrorTreeElement[] children2;
        String newline = SystemProperties.getLineSeparator();
        for (ErrorTreeElement child : children2 = this.myStructure.getChildElements(element)) {
            if (!(child instanceof ErrorTreeElement) || !withUsages && child instanceof NavigatableMessageElement) continue;
            ErrorTreeElement childElement = child;
            if (buffer.length() > 0) {
                buffer.append(newline);
            }
            ErrorViewTextExporter.shift(buffer, indent);
            ErrorViewTextExporter.exportElement(childElement, buffer, indent, newline);
            this.getReportText(buffer, childElement, withUsages, indent + 4);
        }
    }

    public static void exportElement(ErrorTreeElement element, StringBuffer buffer, int baseIntent, String newline) {
        int startLength = buffer.length();
        buffer.append(element.getKind().getPresentableText());
        buffer.append(element.getExportTextPrefix());
        int localIndent = startLength - buffer.length();
        String[] text = element.getText();
        if (text != null && text.length > 0) {
            buffer.append(text[0]);
            for (int i2 = 1; i2 < text.length; ++i2) {
                buffer.append(newline);
                ErrorViewTextExporter.shift(buffer, baseIntent + localIndent);
                buffer.append(text[i2]);
            }
        }
    }

    private static void shift(StringBuffer buffer, int indent) {
        for (int i2 = 0; i2 < indent; ++i2) {
            buffer.append(' ');
        }
    }
}

