/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.smartPointerPsiNodes.FieldSmartPointerNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PsiFieldFavoriteNodeProvider
extends FavoriteNodeProvider {
    public Collection<AbstractTreeNode> getFavoriteNodes(DataContext context, ViewSettings viewSettings) {
        PsiElement element;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project2 == null) {
            return null;
        }
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context);
        if (elements == null && (element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context)) != null) {
            elements = new PsiElement[]{element};
        }
        if (elements != null) {
            ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
            for (PsiElement element2 : elements) {
                if (!(element2 instanceof PsiField)) continue;
                result2.add((AbstractTreeNode)new FieldSmartPointerNode(project2, element2, viewSettings));
            }
            return result2.isEmpty() ? null : result2;
        }
        return null;
    }

    public AbstractTreeNode createNode(Project project2, Object element, ViewSettings viewSettings) {
        if (element instanceof PsiField) {
            return new FieldSmartPointerNode(project2, element, viewSettings);
        }
        return super.createNode(project2, element, viewSettings);
    }

    public boolean elementContainsFile(Object element, VirtualFile vFile) {
        return false;
    }

    public int getElementWeight(Object value2, boolean isSortByType) {
        if (value2 instanceof PsiField) {
            return 4;
        }
        return -1;
    }

    public String getElementLocation(Object element) {
        PsiClass psiClass;
        if (element instanceof PsiField && (psiClass = ((PsiField)element).getContainingClass()) != null) {
            return ClassPresentationUtil.getNameForClass(psiClass, true);
        }
        return null;
    }

    public boolean isInvalidElement(Object element) {
        return element instanceof PsiField && !((PsiField)element).isValid();
    }

    @NotNull
    public String getFavoriteTypeId() {
        return "field";
    }

    public String getElementUrl(Object element) {
        if (element instanceof PsiField) {
            PsiField aField = (PsiField)element;
            return aField.getContainingClass().getQualifiedName() + ";" + aField.getName();
        }
        return null;
    }

    public String getElementModuleName(Object element) {
        if (element instanceof PsiField) {
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiField)element));
            return module2 != null ? module2.getName() : null;
        }
        return null;
    }

    public Object[] createPathFromUrl(Project project2, String url, String moduleName) {
        if (DumbService.isDumb((Project)project2)) {
            return null;
        }
        Module module2 = moduleName != null ? ModuleManager.getInstance((Project)project2).findModuleByName(moduleName) : null;
        GlobalSearchScope scope = module2 != null ? GlobalSearchScope.moduleScope((Module)module2) : GlobalSearchScope.allScope((Project)project2);
        String[] paths = url.split(";");
        if (paths == null || paths.length != 2) {
            return null;
        }
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project2).findClass(paths[0], scope);
        if (aClass == null) {
            return null;
        }
        PsiField aField = aClass.findFieldByName(paths[1], false);
        return new Object[]{aField};
    }
}

