/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.AbstractModuleNode;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddToFavoritesAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.ide.favoritesTreeView.actions.AddToFavoritesAction");
    private final String myFavoritesListName;

    public AddToFavoritesAction(String choosenList) {
        this.getTemplatePresentation().setText(choosenList, false);
        this.myFavoritesListName = choosenList;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Collection<AbstractTreeNode> nodesToAdd = AddToFavoritesAction.getNodesToAdd(dataContext, true);
        if (!nodesToAdd.isEmpty()) {
            Project project2 = e.getProject();
            FavoritesManager.getInstance(project2).addRoots(this.myFavoritesListName, nodesToAdd);
        }
    }

    @NotNull
    public static Collection<AbstractTreeNode> getNodesToAdd(DataContext dataContext, boolean inProjectView) {
        Object elements;
        FavoriteNodeProvider provider2;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return Collections.emptyList();
        }
        Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        Collection<AbstractTreeNode> nodesToAdd = null;
        FavoriteNodeProvider[] favoriteNodeProviderArray = (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)project2);
        int n = favoriteNodeProviderArray.length;
        for (int j = 0; j < n && (nodesToAdd = (provider2 = favoriteNodeProviderArray[j]).getFavoriteNodes(dataContext, ViewSettings.DEFAULT)) == null; ++j) {
        }
        if (nodesToAdd == null && (elements = AddToFavoritesAction.collectSelectedElements(dataContext)) != null) {
            nodesToAdd = AddToFavoritesAction.createNodes(project2, moduleContext, elements, inProjectView, ViewSettings.DEFAULT);
        }
        return nodesToAdd == null ? Collections.emptyList() : nodesToAdd;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(AddToFavoritesAction.canCreateNodes(e, this.myFavoritesListName));
    }

    public static boolean canCreateNodes(AnActionEvent e) {
        return AddToFavoritesAction.canCreateNodes(e, null);
    }

    public static boolean canCreateNodes(AnActionEvent e, @Nullable String listName) {
        DataContext dataContext = e.getDataContext();
        if (e.getProject() == null) {
            return false;
        }
        if (e.getPlace().equals("FavoritesPopup") && FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext) == null) {
            return false;
        }
        boolean inProjectView = e.getPlace().equals("J2EEViewPopup") || e.getPlace().equals("StructureViewPopup") || e.getPlace().equals("ProjectViewPopup");
        Collection<AbstractTreeNode> nodes = AddToFavoritesAction.getNodesToAdd(dataContext, inProjectView);
        if (listName != null && !nodes.isEmpty()) {
            return FavoritesManager.getInstance(e.getProject()).canAddRoots(listName, nodes);
        }
        return !nodes.isEmpty();
    }

    static Object retrieveData(Object object, Object data) {
        return object == null ? data : object;
    }

    private static Object collectSelectedElements(DataContext dataContext) {
        Object elements = AddToFavoritesAction.retrieveData(null, CommonDataKeys.PSI_ELEMENT.getData(dataContext));
        elements = AddToFavoritesAction.retrieveData(elements, LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext));
        elements = AddToFavoritesAction.retrieveData(elements, CommonDataKeys.PSI_FILE.getData(dataContext));
        elements = AddToFavoritesAction.retrieveData(elements, ModuleGroup.ARRAY_DATA_KEY.getData(dataContext));
        elements = AddToFavoritesAction.retrieveData(elements, LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext));
        elements = AddToFavoritesAction.retrieveData(elements, LibraryGroupElement.ARRAY_DATA_KEY.getData(dataContext));
        elements = AddToFavoritesAction.retrieveData(elements, NamedLibraryElement.ARRAY_DATA_KEY.getData(dataContext));
        elements = AddToFavoritesAction.retrieveData(elements, CommonDataKeys.VIRTUAL_FILE.getData(dataContext));
        elements = AddToFavoritesAction.retrieveData(elements, CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext));
        return elements;
    }

    @NotNull
    public static Collection<AbstractTreeNode> createNodes(Project project2, Module moduleContext, Object object, boolean inProjectView, ViewSettings favoritesConfig) {
        if (project2 == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
        for (FavoriteNodeProvider favoriteNodeProvider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)project2)) {
            AbstractTreeNode treeNode = favoriteNodeProvider.createNode(project2, (Object)object, favoritesConfig);
            if (treeNode == null) continue;
            result2.add(treeNode);
            return result2;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        String currentViewId = ProjectView.getInstance(project2).getCurrentViewId();
        AbstractProjectViewPane pane = ProjectView.getInstance(project2).getProjectViewPaneById(currentViewId);
        if (object instanceof PsiElement[]) {
            for (PsiElement psiElement : (PsiElement[])object) {
                AddToFavoritesAction.addPsiElementNode(psiElement, project2, result2, favoritesConfig);
            }
            return result2;
        }
        if (object instanceof PsiElement) {
            Object var9_13 = null;
            if (inProjectView && ProjectView.getInstance(project2).isShowModules(currentViewId) && pane != null && pane.getSelectedDescriptor() != null && pane.getSelectedDescriptor().getElement() instanceof AbstractTreeNode) {
                AbstractTreeNode abstractTreeNode;
                for (abstractTreeNode = (AbstractTreeNode)pane.getSelectedDescriptor().getElement(); abstractTreeNode != null && !(abstractTreeNode.getParent() instanceof AbstractModuleNode); abstractTreeNode = abstractTreeNode.getParent()) {
                }
                if (abstractTreeNode != null) {
                    Module module2 = (Module)((AbstractModuleNode)abstractTreeNode.getParent()).getValue();
                }
            }
            AddToFavoritesAction.addPsiElementNode((PsiElement)object, project2, result2, favoritesConfig);
            return result2;
        }
        if (object instanceof VirtualFile[]) {
            for (VirtualFile vFile : (VirtualFile[])object) {
                PsiFile element = psiManager.findFile(vFile);
                if (element == null) {
                    element = psiManager.findDirectory(vFile);
                }
                AddToFavoritesAction.addPsiElementNode((PsiElement)element, project2, result2, favoritesConfig);
            }
            return result2;
        }
        if (object instanceof VirtualFile) {
            VirtualFile virtualFile = (VirtualFile)object;
            PsiFile psiFile = psiManager.findFile(virtualFile);
            AddToFavoritesAction.addPsiElementNode((PsiElement)psiFile, project2, result2, favoritesConfig);
            return result2;
        }
        if (object instanceof ModuleGroup[]) {
            for (ModuleGroup moduleGroup : (ModuleGroup[])object) {
                result2.add((AbstractTreeNode)new ProjectViewModuleGroupNode(project2, moduleGroup, favoritesConfig));
            }
            return result2;
        }
        if (object instanceof Module) {
            object = new Module[]{(Module)object};
        }
        if (object instanceof Module[]) {
            for (Module module1 : object) {
                result2.add((AbstractTreeNode)new ProjectViewModuleNode(project2, module1, favoritesConfig));
            }
            return result2;
        }
        if (object instanceof LibraryGroupElement[]) {
            for (LibraryGroupElement libraryGroup : (LibraryGroupElement[])object) {
                result2.add((AbstractTreeNode)new LibraryGroupNode(project2, libraryGroup, favoritesConfig));
            }
            return result2;
        }
        if (object instanceof NamedLibraryElement[]) {
            for (NamedLibraryElement namedLibrary : (NamedLibraryElement[])object) {
                result2.add((AbstractTreeNode)new NamedLibraryElementNode(project2, namedLibrary, favoritesConfig));
            }
            return result2;
        }
        return result2;
    }

    private static void addPsiElementNode(PsiElement psiElement, Project project2, ArrayList<AbstractTreeNode> result2, ViewSettings favoritesConfig) {
        Class<Object> klass = AddToFavoritesAction.getPsiElementNodeClass(psiElement);
        if (klass == null && (psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiFile.class)) != null) {
            klass = PsiFileNode.class;
        }
        PsiElement value2 = psiElement;
        try {
            if (klass != null && value2 != null) {
                result2.add(ProjectViewNode.createTreeNode(klass, (Project)project2, (Object)value2, (ViewSettings)favoritesConfig));
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static Class<? extends AbstractTreeNode> getPsiElementNodeClass(PsiElement psiElement) {
        Class klass = null;
        if (psiElement instanceof PsiFile) {
            klass = PsiFileNode.class;
        } else if (psiElement instanceof PsiDirectory) {
            klass = PsiDirectoryNode.class;
        }
        return klass;
    }
}

