/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.favoritesTreeView.FavoritesViewTreeBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.ui.CommonActionsPanel;
import java.util.Set;

public class EditFavoritesAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        FavoritesViewTreeBuilder treeBuilder = (FavoritesViewTreeBuilder)((Object)FavoritesTreeViewPanel.FAVORITES_TREE_BUILDER_KEY.getData(e.getDataContext()));
        String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(e.getDataContext());
        if (project2 == null || treeBuilder == null || listName == null) {
            return;
        }
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project2);
        FavoritesListProvider provider2 = favoritesManager.getListProvider(listName);
        Set selection = treeBuilder.getSelectedElements();
        if (provider2 != null && provider2.willHandle(CommonActionsPanel.Buttons.EDIT, project2, selection)) {
            provider2.handle(CommonActionsPanel.Buttons.EDIT, project2, selection, treeBuilder.getTree());
            return;
        }
        favoritesManager.renameList(project2, listName);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setText(this.getTemplatePresentation().getText());
        e.getPresentation().setIcon(CommonActionsPanel.Buttons.EDIT.getIcon());
        e.getPresentation().setEnabled(true);
        Project project2 = e.getProject();
        FavoritesViewTreeBuilder treeBuilder = (FavoritesViewTreeBuilder)((Object)FavoritesTreeViewPanel.FAVORITES_TREE_BUILDER_KEY.getData(e.getDataContext()));
        String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(e.getDataContext());
        if (project2 == null || treeBuilder == null || listName == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project2);
        FavoritesListProvider provider2 = favoritesManager.getListProvider(listName);
        Set selection = treeBuilder.getSelectedElements();
        if (provider2 != null) {
            e.getPresentation().setEnabled(provider2.willHandle(CommonActionsPanel.Buttons.EDIT, project2, selection));
            e.getPresentation().setText(provider2.getCustomName(CommonActionsPanel.Buttons.EDIT));
        }
    }
}

