/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.actions;

import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.ui.CreateFromTemplateDialog;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateFromTemplateActionBase
extends AnAction {
    public CreateFromTemplateActionBase(String title, String description, Icon icon) {
        super(title, description, icon);
    }

    public final void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        PsiDirectory dir = this.getTargetDirectory(dataContext, view);
        if (dir == null) {
            return;
        }
        Project project2 = dir.getProject();
        FileTemplate selectedTemplate = this.getTemplate(project2, dir);
        if (selectedTemplate != null) {
            AnAction action = this.getReplacedAction(selectedTemplate);
            if (action != null) {
                action.actionPerformed(e);
            } else {
                FileTemplateManager.getInstance(project2).addRecentName(selectedTemplate.getName());
                AttributesDefaults defaults = this.getAttributesDefaults(dataContext);
                Properties properties = defaults != null ? defaults.getDefaultProperties() : null;
                CreateFromTemplateDialog dialog2 = new CreateFromTemplateDialog(project2, dir, selectedTemplate, defaults, properties);
                PsiElement createdElement = dialog2.create();
                if (createdElement != null) {
                    this.elementCreated(dialog2, createdElement);
                    view.selectElement(createdElement);
                    if (selectedTemplate.isLiveTemplateEnabled() && createdElement instanceof PsiFile) {
                        Map<String, String> defaultValues = this.getLiveTemplateDefaults(dataContext, (PsiFile)createdElement);
                        CreateFromTemplateActionBase.startLiveTemplate((PsiFile)createdElement, (Map)ObjectUtils.notNull(defaultValues, Collections.emptyMap()));
                    }
                }
            }
        }
    }

    public static void startLiveTemplate(@NotNull PsiFile file2) {
        CreateFromTemplateActionBase.startLiveTemplate(file2, Collections.emptyMap());
    }

    public static void startLiveTemplate(@NotNull PsiFile file2, @NotNull Map<String, String> defaultValues) {
        Editor editor = EditorHelper.openInEditor((PsiElement)file2);
        if (editor == null) {
            return;
        }
        TemplateImpl template = new TemplateImpl("", file2.getText(), "");
        template.setInline(true);
        int count = template.getSegmentsCount();
        if (count == 0) {
            return;
        }
        HashSet<String> variables = new HashSet<String>();
        for (int i = 0; i < count; ++i) {
            variables.add(template.getSegmentName(i));
        }
        variables.removeAll(TemplateImpl.INTERNAL_VARS_SET);
        for (String variable : variables) {
            String defaultValue = defaultValues.getOrDefault(variable, variable);
            template.addVariable(variable, null, '\"' + defaultValue + '\"', true);
        }
        Project project2 = file2.getProject();
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> editor.getDocument().setText((CharSequence)template.getTemplateText()));
        editor.getCaretModel().moveToOffset(0);
        TemplateManager.getInstance(project2).startTemplate(editor, template);
    }

    @Nullable
    protected PsiDirectory getTargetDirectory(DataContext dataContext, IdeView view) {
        return DirectoryChooserUtil.getOrChooseDirectory(view);
    }

    protected abstract FileTemplate getTemplate(Project var1, PsiDirectory var2);

    @Nullable
    protected AnAction getReplacedAction(FileTemplate selectedTemplate) {
        return null;
    }

    @Nullable
    protected AttributesDefaults getAttributesDefaults(DataContext dataContext) {
        return null;
    }

    protected void elementCreated(CreateFromTemplateDialog dialog2, PsiElement createdElement) {
    }

    @Nullable
    protected Map<String, String> getLiveTemplateDefaults(DataContext dataContext, @NotNull PsiFile file2) {
        return null;
    }
}

