/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplatesScheme;
import com.intellij.ide.fileTemplates.InternalTemplateBean;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.ExportableFileTemplateSettings;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.FileTemplateSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.project.ProjectKt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="FileTemplateManagerImpl", storages={@Storage(value="$WORKSPACE_FILE$")})
public class FileTemplateManagerImpl
extends FileTemplateManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl");
    private final State myState = new State();
    private final FileTypeManagerEx myTypeManager;
    private final FileTemplateSettings myProjectSettings;
    private final ExportableFileTemplateSettings myDefaultSettings;
    private final Project myProject;
    private final FileTemplatesScheme myProjectScheme;
    private FileTemplatesScheme myScheme = FileTemplatesScheme.DEFAULT;
    private boolean myInitialized;
    private Date myTestDate;

    public static FileTemplateManagerImpl getInstanceImpl(@NotNull Project project2) {
        return (FileTemplateManagerImpl)FileTemplateManagerImpl.getInstance(project2);
    }

    public FileTemplateManagerImpl(@NotNull FileTypeManagerEx typeManager, FileTemplateSettings projectSettings, ExportableFileTemplateSettings defaultSettings, ProjectManager pm, final Project project2) {
        this.myTypeManager = typeManager;
        this.myProjectSettings = projectSettings;
        this.myDefaultSettings = defaultSettings;
        this.myProject = project2;
        this.myProjectScheme = project2.isDefault() ? null : new FileTemplatesScheme("Project"){

            @Override
            @NotNull
            public String getTemplatesDir() {
                return FileUtilRt.toSystemDependentName((String)(ProjectKt.getStateStore(project2).getDirectoryStorePath(false) + "/" + "fileTemplates"));
            }

            @Override
            @NotNull
            public Project getProject() {
                return project2;
            }
        };
    }

    private FileTemplateSettings getSettings() {
        return this.myScheme == FileTemplatesScheme.DEFAULT ? this.myDefaultSettings : this.myProjectSettings;
    }

    @Override
    @NotNull
    public FileTemplatesScheme getCurrentScheme() {
        return this.myScheme;
    }

    @Override
    public void setCurrentScheme(@NotNull FileTemplatesScheme scheme2) {
        for (FTManager child : this.getAllManagers()) {
            child.saveTemplates();
        }
        this.setScheme(scheme2);
    }

    private void setScheme(@NotNull FileTemplatesScheme scheme2) {
        this.myScheme = scheme2;
        this.myInitialized = true;
    }

    @Override
    protected FileTemplateManager checkInitialized() {
        if (!this.myInitialized) {
            this.setScheme(this.myScheme);
        }
        return this;
    }

    @Override
    @Nullable
    public FileTemplatesScheme getProjectScheme() {
        return this.myProjectScheme;
    }

    @Override
    public FileTemplate[] getTemplates(String category) {
        if ("Default".equals(category)) {
            return (FileTemplate[])ArrayUtil.mergeArrays((Object[])this.getInternalTemplates(), (Object[])this.getAllTemplates());
        }
        if ("Includes".equals(category)) {
            return this.getAllPatterns();
        }
        if ("Code".equals(category)) {
            return this.getAllCodeTemplates();
        }
        if ("J2EE".equals(category)) {
            return this.getAllJ2eeTemplates();
        }
        throw new IllegalArgumentException("Unknown category: " + category);
    }

    @Override
    @NotNull
    public FileTemplate[] getAllTemplates() {
        Collection<FileTemplateBase> templates = this.getSettings().getDefaultTemplatesManager().getAllTemplates(false);
        return templates.toArray(new FileTemplate[templates.size()]);
    }

    @Override
    public FileTemplate getTemplate(@NotNull String templateName) {
        return this.getSettings().getDefaultTemplatesManager().findTemplateByName(templateName);
    }

    @Override
    @NotNull
    public FileTemplate addTemplate(@NotNull String name, @NotNull String extension) {
        return this.getSettings().getDefaultTemplatesManager().addTemplate(name, extension);
    }

    @Override
    public void removeTemplate(@NotNull FileTemplate template) {
        String qName = ((FileTemplateBase)template).getQualifiedName();
        for (FTManager manager : this.getAllManagers()) {
            manager.removeTemplate(qName);
        }
    }

    @Override
    @NotNull
    public Properties getDefaultProperties() {
        Properties props = new Properties();
        Calendar calendar = Calendar.getInstance();
        Date date = this.myTestDate == null ? calendar.getTime() : this.myTestDate;
        SimpleDateFormat sdfMonthNameShort = new SimpleDateFormat("MMM");
        SimpleDateFormat sdfMonthNameFull = new SimpleDateFormat("MMMM");
        SimpleDateFormat sdfDayNameShort = new SimpleDateFormat("EEE");
        SimpleDateFormat sdfDayNameFull = new SimpleDateFormat("EEEE");
        SimpleDateFormat sdfYearFull = new SimpleDateFormat("yyyy");
        props.setProperty("DATE", DateFormatUtil.formatDate((Date)date));
        props.setProperty("TIME", DateFormatUtil.formatTime((Date)date));
        props.setProperty("YEAR", sdfYearFull.format(date));
        props.setProperty("MONTH", FileTemplateManagerImpl.getCalendarValue(calendar, 2));
        props.setProperty("MONTH_NAME_SHORT", sdfMonthNameShort.format(date));
        props.setProperty("MONTH_NAME_FULL", sdfMonthNameFull.format(date));
        props.setProperty("DAY", FileTemplateManagerImpl.getCalendarValue(calendar, 5));
        props.setProperty("DAY_NAME_SHORT", sdfDayNameShort.format(date));
        props.setProperty("DAY_NAME_FULL", sdfDayNameFull.format(date));
        props.setProperty("HOUR", FileTemplateManagerImpl.getCalendarValue(calendar, 11));
        props.setProperty("MINUTE", FileTemplateManagerImpl.getCalendarValue(calendar, 12));
        props.setProperty("SECOND", FileTemplateManagerImpl.getCalendarValue(calendar, 13));
        props.setProperty("USER", SystemProperties.getUserName());
        props.setProperty("PRODUCT_NAME", ApplicationNamesInfo.getInstance().getFullProductName());
        props.setProperty("DS", "$");
        props.setProperty("PROJECT_NAME", this.myProject.getName());
        return props;
    }

    @NotNull
    private static String getCalendarValue(Calendar calendar, int field) {
        String result2;
        int val = calendar.get(field);
        if (field == 2) {
            ++val;
        }
        if ((result2 = Integer.toString(val)).length() == 1) {
            return "0" + result2;
        }
        return result2;
    }

    @Override
    @NotNull
    public Collection<String> getRecentNames() {
        this.validateRecentNames();
        return this.myState.getRecentNames(25);
    }

    @Override
    public void addRecentName(@NotNull @NonNls String name) {
        this.myState.addName(name);
    }

    private void validateRecentNames() {
        Collection<FileTemplateBase> allTemplates = this.getSettings().getDefaultTemplatesManager().getAllTemplates(false);
        ArrayList<String> allNames = new ArrayList<String>(allTemplates.size());
        for (FileTemplate fileTemplate : allTemplates) {
            allNames.add(fileTemplate.getName());
        }
        this.myState.validateNames(allNames);
    }

    @Override
    @NotNull
    public FileTemplate[] getInternalTemplates() {
        InternalTemplateBean[] internalTemplateBeans = (InternalTemplateBean[])Extensions.getExtensions(InternalTemplateBean.EP_NAME);
        FileTemplate[] result2 = new FileTemplate[internalTemplateBeans.length];
        for (int i = 0; i < internalTemplateBeans.length; ++i) {
            result2[i] = this.getInternalTemplate(internalTemplateBeans[i].name);
        }
        return result2;
    }

    @Override
    public FileTemplate getInternalTemplate(@NotNull @NonNls String templateName) {
        FileTemplateBase template = (FileTemplateBase)this.findInternalTemplate(templateName);
        if (template == null) {
            template = (FileTemplateBase)this.getJ2eeTemplate(templateName);
            if (template != null) {
                template.setReformatCode(true);
            } else {
                String text = FileTemplateManagerImpl.normalizeText(this.getDefaultClassTemplateText(templateName));
                template = this.getSettings().getInternalTemplatesManager().addTemplate(templateName, "java");
                template.setText(text);
            }
        }
        return template;
    }

    @Override
    public FileTemplate findInternalTemplate(@NotNull @NonNls String templateName) {
        FileTemplateBase template = this.getSettings().getInternalTemplatesManager().findTemplateByName(templateName);
        if (template == null) {
            template = this.getSettings().getDefaultTemplatesManager().findTemplateByName(templateName);
        }
        return template;
    }

    @NotNull
    public static String normalizeText(@NotNull String text) {
        text = StringUtil.convertLineSeparators((String)text);
        text = StringUtil.replace((String)text, (String)"$NAME$", (String)"${NAME}");
        text = StringUtil.replace((String)text, (String)"$PACKAGE_NAME$", (String)"${PACKAGE_NAME}");
        text = StringUtil.replace((String)text, (String)"$DATE$", (String)"${DATE}");
        text = StringUtil.replace((String)text, (String)"$TIME$", (String)"${TIME}");
        text = StringUtil.replace((String)text, (String)"$USER$", (String)"${USER}");
        return text;
    }

    @Override
    @NotNull
    public String internalTemplateToSubject(@NotNull @NonNls String templateName) {
        for (InternalTemplateBean bean : (InternalTemplateBean[])Extensions.getExtensions(InternalTemplateBean.EP_NAME)) {
            if (!bean.name.equals(templateName) || bean.subject == null) continue;
            return bean.subject;
        }
        return templateName.toLowerCase();
    }

    @Override
    @NotNull
    public String localizeInternalTemplateName(@NotNull FileTemplate template) {
        return template.getName();
    }

    @NonNls
    @NotNull
    private String getDefaultClassTemplateText(@NotNull @NonNls String templateName) {
        return IdeBundle.message((String)"template.default.class.comment", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}) + "package $PACKAGE_NAME$;\npublic " + this.internalTemplateToSubject(templateName) + " $NAME$ { }";
    }

    @Override
    public FileTemplate getCodeTemplate(@NotNull @NonNls String templateName) {
        return FileTemplateManagerImpl.getTemplateFromManager(templateName, this.getSettings().getCodeTemplatesManager());
    }

    @Override
    public FileTemplate getJ2eeTemplate(@NotNull @NonNls String templateName) {
        return FileTemplateManagerImpl.getTemplateFromManager(templateName, this.getSettings().getJ2eeTemplatesManager());
    }

    @Nullable
    private static FileTemplate getTemplateFromManager(@NotNull String templateName, @NotNull FTManager ftManager) {
        FileTemplateBase template = ftManager.getTemplate(templateName);
        if (template != null) {
            return template;
        }
        template = ftManager.findTemplateByName(templateName);
        if (template != null) {
            return template;
        }
        if (templateName.endsWith("ForTest") && ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        String message2 = "Template not found: " + templateName;
        LOG.error(message2);
        return null;
    }

    @Override
    @NotNull
    public FileTemplate getDefaultTemplate(@NotNull String name) {
        String templateQName = this.myTypeManager.getExtension(name).isEmpty() ? FileTemplateBase.getQualifiedName(name, "java") : name;
        for (FTManager manager : this.getAllManagers()) {
            FileTemplateBase template = manager.getTemplate(templateQName);
            if (!(template instanceof BundledFileTemplate)) continue;
            BundledFileTemplate copy = ((BundledFileTemplate)template).clone();
            copy.revertToDefaults();
            return copy;
        }
        String message2 = "Default template not found: " + name;
        LOG.error(message2);
        return null;
    }

    @Override
    @NotNull
    public FileTemplate[] getAllPatterns() {
        Collection<FileTemplateBase> allTemplates = this.getSettings().getPatternsManager().getAllTemplates(false);
        return allTemplates.toArray(new FileTemplate[allTemplates.size()]);
    }

    @Override
    public FileTemplate getPattern(@NotNull String name) {
        return this.getSettings().getPatternsManager().findTemplateByName(name);
    }

    @Override
    @NotNull
    public FileTemplate[] getAllCodeTemplates() {
        Collection<FileTemplateBase> templates = this.getSettings().getCodeTemplatesManager().getAllTemplates(false);
        return templates.toArray(new FileTemplate[templates.size()]);
    }

    @Override
    @NotNull
    public FileTemplate[] getAllJ2eeTemplates() {
        Collection<FileTemplateBase> templates = this.getSettings().getJ2eeTemplatesManager().getAllTemplates(false);
        return templates.toArray(new FileTemplate[templates.size()]);
    }

    @Override
    public void setTemplates(@NotNull String templatesCategory, @NotNull Collection<FileTemplate> templates) {
        for (FTManager manager : this.getAllManagers()) {
            if (!templatesCategory.equals(manager.getName())) continue;
            manager.updateTemplates(templates);
            break;
        }
    }

    @Override
    public void saveAllTemplates() {
        for (FTManager manager : this.getAllManagers()) {
            manager.saveTemplates();
        }
    }

    public URL getDefaultTemplateDescription() {
        return this.myDefaultSettings.getDefaultTemplateDescription();
    }

    public URL getDefaultIncludeDescription() {
        return this.myDefaultSettings.getDefaultIncludeDescription();
    }

    public void setTestDate(Date testDate) {
        this.myTestDate = testDate;
    }

    @Nullable
    public State getState() {
        this.myState.SCHEME = this.myScheme.getName();
        return this.myState;
    }

    public void loadState(State state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
        FileTemplatesScheme scheme2 = this.myProjectScheme != null && this.myProjectScheme.getName().equals(state.SCHEME) ? this.myProjectScheme : FileTemplatesScheme.DEFAULT;
        this.setScheme(scheme2);
    }

    private FTManager[] getAllManagers() {
        return this.getSettings().getAllManagers();
    }

    public static class State {
        public List<String> RECENT_TEMPLATES = new ArrayList<String>();
        public String SCHEME = FileTemplatesScheme.DEFAULT.getName();

        public void addName(@NotNull @NonNls String name) {
            this.RECENT_TEMPLATES.remove(name);
            this.RECENT_TEMPLATES.add(name);
        }

        @NotNull
        public Collection<String> getRecentNames(int max) {
            int size = this.RECENT_TEMPLATES.size();
            int resultSize = Math.min(max, size);
            return this.RECENT_TEMPLATES.subList(size - resultSize, size);
        }

        public void validateNames(List<String> validNames) {
            this.RECENT_TEMPLATES.retainAll(validNames);
        }
    }
}

