/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.AllFileTemplatesConfigurable;
import com.intellij.ide.fileTemplates.impl.FileTemplateTab;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

abstract class FileTemplateTabAsList
extends FileTemplateTab {
    private final JList myList = new JBList();
    private MyListModel myModel;

    FileTemplateTabAsList(String title) {
        super(title);
        this.myList.setSelectionMode(0);
        this.myList.setCellRenderer(new MyListCellRenderer());
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FileTemplateTabAsList.this.onTemplateSelected();
            }
        });
        new ListSpeedSearch(this.myList, new Function<Object, String>(){

            public String fun(Object o) {
                if (o instanceof FileTemplate) {
                    return ((FileTemplate)o).getName();
                }
                return null;
            }
        });
    }

    @Override
    public void removeSelected() {
        FileTemplate selectedTemplate = this.getSelectedTemplate();
        if (selectedTemplate == null) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.myList.getModel();
        int selectedIndex = this.myList.getSelectedIndex();
        model.remove(selectedIndex);
        if (!model.isEmpty()) {
            this.myList.setSelectedIndex(Math.min(selectedIndex, model.size() - 1));
        }
        this.onTemplateSelected();
    }

    @Override
    protected void initSelection(FileTemplate selection) {
        this.myModel = new MyListModel();
        this.myList.setModel(this.myModel);
        for (FileTemplate template : this.myTemplates) {
            this.myModel.addElement(template);
        }
        if (selection != null) {
            this.selectTemplate(selection);
        } else if (this.myList.getModel().getSize() > 0) {
            this.myList.setSelectedIndex(0);
        }
    }

    @Override
    public void fireDataChanged() {
        this.myModel.fireListDataChanged();
    }

    @Override
    @NotNull
    public FileTemplate[] getTemplates() {
        int size = this.myModel.getSize();
        ArrayList<FileTemplate> templates = new ArrayList<FileTemplate>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            templates.add((FileTemplate)this.myModel.getElementAt(i2));
        }
        return templates.toArray(new FileTemplate[templates.size()]);
    }

    @Override
    public void addTemplate(FileTemplate newTemplate) {
        this.myModel.addElement(newTemplate);
    }

    @Override
    public void selectTemplate(FileTemplate template) {
        this.myList.setSelectedValue(template, true);
    }

    @Override
    public FileTemplate getSelectedTemplate() {
        Object value2 = this.myList.getSelectedValue();
        return value2 instanceof FileTemplate ? (FileTemplate)value2 : null;
    }

    @Override
    public JComponent getComponent() {
        return this.myList;
    }

    private static class MyListModel
    extends DefaultListModel {
        private MyListModel() {
        }

        public void fireListDataChanged() {
            int size = this.getSize();
            if (size > 0) {
                this.fireContentsChanged(this, 0, size - 1);
            }
        }
    }

    private class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value2, index, isSelected, cellHasFocus);
            Icon icon = null;
            if (value2 instanceof FileTemplate) {
                FileTemplate template = (FileTemplate)value2;
                icon = FileTemplateUtil.getIcon(template);
                boolean internalTemplate = AllFileTemplatesConfigurable.isInternalTemplate(template.getName(), FileTemplateTabAsList.this.getTitle());
                if (internalTemplate) {
                    this.setFont(this.getFont().deriveFont(1));
                    this.setText(template.getName());
                } else {
                    this.setFont(this.getFont().deriveFont(0));
                    this.setText(template.getName());
                }
                if (!template.isDefault() && !isSelected) {
                    this.setForeground(FileTemplateTab.MODIFIED_FOREGROUND);
                }
            }
            this.setIcon(icon);
            return this;
        }
    }
}

