/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.hierarchy.HierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

class ExporterToTextFileHierarchy
implements ExporterToTextFile {
    private static final Logger LOG = Logger.getInstance(ExporterToTextFileHierarchy.class);
    private final HierarchyBrowserBase myHierarchyBrowserBase;

    public ExporterToTextFileHierarchy(@NotNull HierarchyBrowserBase hierarchyBrowserBase) {
        this.myHierarchyBrowserBase = hierarchyBrowserBase;
    }

    public JComponent getSettingsEditor() {
        return null;
    }

    public void addSettingsChangedListener(ChangeListener listener2) throws TooManyListenersException {
    }

    public void removeSettingsChangedListener(ChangeListener listener2) {
    }

    @NotNull
    public String getReportText() {
        StringBuilder buf = new StringBuilder();
        HierarchyTreeBuilder currentBuilder = this.myHierarchyBrowserBase.getCurrentBuilder();
        LOG.assertTrue(currentBuilder != null);
        this.appendNode(buf, currentBuilder.getRootNode(), SystemProperties.getLineSeparator(), "");
        return buf.toString();
    }

    private void appendNode(StringBuilder buf, DefaultMutableTreeNode node, String lineSeparator, String indent) {
        String childIndent;
        if (node.getParent() != null) {
            childIndent = indent + "    ";
            HierarchyNodeDescriptor descriptor = this.myHierarchyBrowserBase.getDescriptor(node);
            if (descriptor != null) {
                buf.append(indent).append(descriptor.getHighlightedText().getText()).append(lineSeparator);
            }
        } else {
            childIndent = indent;
        }
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
            this.appendNode(buf, child, lineSeparator, childIndent);
        }
    }

    @NotNull
    public String getDefaultFilePath() {
        HierarchyBrowserManager.State state = HierarchyBrowserManager.getInstance(this.myHierarchyBrowserBase.myProject).getState();
        return state != null && state.EXPORT_FILE_PATH != null ? state.EXPORT_FILE_PATH : "";
    }

    public void exportedTo(String filePath) {
        HierarchyBrowserManager.State state = HierarchyBrowserManager.getInstance(this.myHierarchyBrowserBase.myProject).getState();
        if (state != null) {
            state.EXPORT_FILE_PATH = filePath;
        }
    }

    public boolean canExport() {
        return this.myHierarchyBrowserBase.getCurrentBuilder() != null;
    }
}

