/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.method;

import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.MethodHierarchyBrowserBase;
import com.intellij.ide.hierarchy.method.MethodHierarchyBrowser;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodHierarchyProvider
implements HierarchyProvider {
    public PsiElement getTarget(@NotNull DataContext dataContext) {
        PsiMethod method2 = JavaMethodHierarchyProvider.getMethodImpl(dataContext);
        if (method2 != null && method2.getContainingClass() != null && !method2.hasModifierProperty("private") && !method2.hasModifierProperty("static")) {
            return method2;
        }
        return null;
    }

    @Nullable
    private static PsiMethod getMethodImpl(DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return null;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false);
        if (method2 != null) {
            return method2;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset < 1) {
            return null;
        }
        element = psiFile.findElementAt(offset);
        if (!(element instanceof PsiWhiteSpace)) {
            return null;
        }
        element = psiFile.findElementAt(offset - 1);
        if (!(element instanceof PsiJavaToken) || ((PsiJavaToken)element).getTokenType() != JavaTokenType.SEMICOLON) {
            return null;
        }
        return (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false);
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(PsiElement target) {
        return new MethodHierarchyBrowser(target.getProject(), (PsiMethod)target);
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        ((MethodHierarchyBrowser)hierarchyBrowser).changeView(MethodHierarchyBrowserBase.METHOD_TYPE);
    }
}

