/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter;

import com.intellij.lang.Language;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.XmlCharsetDetector;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlLikeFileType
extends LanguageFileType {
    public XmlLikeFileType(Language language) {
        super(language);
    }

    public String getCharset(@NotNull VirtualFile file2, @NotNull byte[] content) {
        Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessed = LoadTextUtil.guessFromContent(file2, content, content.length);
        String charset = guessed != null && guessed.first != null ? ((Charset)guessed.first).name() : XmlCharsetDetector.extractXmlEncodingFromProlog((byte[])content);
        return charset == null ? "UTF-8" : charset;
    }

    public Charset extractCharsetFromFileContent(Project project2, @Nullable VirtualFile file2, @NotNull CharSequence content) {
        String name = XmlCharsetDetector.extractXmlEncodingFromProlog((CharSequence)content);
        Charset charset = CharsetToolkit.forName((String)name);
        return charset == null ? CharsetToolkit.UTF8_CHARSET : charset;
    }

    public boolean isCaseSensitive() {
        return false;
    }
}

