/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class FileDirPathFromParentMacro
extends Macro {
    private static final String PATH_DELIMITER = "/";

    @Override
    public String getName() {
        return "FileDirPathFromParent";
    }

    @Override
    public String getDescription() {
        return IdeBundle.message((String)"macro.file.directory.from.parent", (Object[])new Object[0]);
    }

    @Override
    public String expand(DataContext dataContext) {
        return null;
    }

    @Override
    public String expand(DataContext dataContext, String ... args) throws Macro.ExecutionCancelledException {
        if (args.length == 0) {
            return super.expand(dataContext, args);
        }
        VirtualFile dir = FileDirPathFromParentMacro.getVirtualDirOrParent(dataContext);
        if (dir == null) {
            return "";
        }
        String dirPath = dir.getPath();
        String surroundedSubDir = FileDirPathFromParentMacro.surroundWithSlashes(FileUtil.toSystemIndependentName((String)args[0]));
        String surroundedDirPath = FileDirPathFromParentMacro.surroundWithSlashes(dirPath);
        if (surroundedSubDir.length() == 1) {
            return FileUtil.toSystemDependentName((String)surroundedDirPath.substring(1));
        }
        int ind = FileDirPathFromParentMacro.lastIndexOf(surroundedDirPath, surroundedSubDir, surroundedDirPath.length(), !SystemInfo.isFileSystemCaseSensitive);
        if (ind >= 0) {
            return FileUtil.toSystemDependentName((String)surroundedDirPath.substring(ind + surroundedSubDir.length()));
        }
        return FileUtil.toSystemDependentName((String)(dirPath.endsWith(PATH_DELIMITER) ? dirPath : dirPath + PATH_DELIMITER));
    }

    private static int lastIndexOf(@NotNull CharSequence buffer, @NotNull String pattern, int maxIndex, boolean ignoreCase) {
        int patternLength = pattern.length();
        int end = buffer.length() - patternLength;
        if (maxIndex > end) {
            maxIndex = end;
        }
        for (int i2 = maxIndex; i2 >= 0; --i2) {
            boolean found = true;
            for (int j = 0; j < patternLength; ++j) {
                if (ignoreCase) {
                    if (StringUtil.charsEqualIgnoreCase((char)pattern.charAt(j), (char)buffer.charAt(i2 + j))) continue;
                    found = false;
                    break;
                }
                if (pattern.charAt(j) == buffer.charAt(i2 + j)) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i2;
        }
        return -1;
    }

    @NotNull
    private static String surroundWithSlashes(@NotNull String path) {
        boolean append;
        if (path.isEmpty()) {
            return PATH_DELIMITER;
        }
        boolean prepend = !path.startsWith(PATH_DELIMITER);
        boolean bl = append = !path.endsWith(PATH_DELIMITER);
        if (prepend && append) {
            return PATH_DELIMITER + path + PATH_DELIMITER;
        }
        if (prepend) {
            path = PATH_DELIMITER + path;
        }
        if (append) {
            path = path + PATH_DELIMITER;
        }
        return path;
    }
}

