/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.KeePassCredentialStore;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.PasswordSafeSettingsListener;
import com.intellij.credentialStore.ProviderType;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.PasswordStorage;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImplKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.util.concurrency.AppExecutorUtil;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0096\u0002J\u0018\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u001dH\u0016J\b\u0010&\u001a\u00020\u001bH\u0016J\u001b\u0010'\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010%\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J#\u0010'\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010%\u001a\u0004\u0018\u00010\u001d2\u0006\u0010(\u001a\u00020#H\u0096\u0002R\u001e\u0010\u0005\u001a\u00020\u00068\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\tR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u00148FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u000e\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006)"}, d2={"Lcom/intellij/ide/passwordSafe/impl/PasswordSafeImpl;", "Lcom/intellij/ide/passwordSafe/PasswordSafe;", "Lcom/intellij/openapi/components/SettingsSavingComponent;", "settings", "Lcom/intellij/credentialStore/PasswordSafeSettings;", "currentProvider", "Lcom/intellij/credentialStore/CredentialStore;", "(Lcom/intellij/credentialStore/PasswordSafeSettings;Lcom/intellij/credentialStore/CredentialStore;)V", "getCurrentProvider$credential_store", "()Lcom/intellij/credentialStore/CredentialStore;", "setCurrentProvider$credential_store", "(Lcom/intellij/credentialStore/CredentialStore;)V", "masterKeyProvider", "masterKeyProvider$annotations", "()V", "getMasterKeyProvider", "memoryHelperProvider", "Lkotlin/Lazy;", "Lcom/intellij/credentialStore/KeePassCredentialStore;", "memoryProvider", "Lcom/intellij/ide/passwordSafe/PasswordStorage;", "memoryProvider$annotations", "getMemoryProvider", "()Lcom/intellij/ide/passwordSafe/PasswordStorage;", "getSettings", "()Lcom/intellij/credentialStore/PasswordSafeSettings;", "clearPasswords", "", "get", "Lcom/intellij/credentialStore/Credentials;", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "getAsync", "Lorg/jetbrains/concurrency/Promise;", "isMemoryOnly", "", "isPasswordStoredOnlyInMemory", "credentials", "save", "set", "memoryOnly", "credential-store"})
public final class PasswordSafeImpl
extends PasswordSafe
implements SettingsSavingComponent {
    private final Lazy<KeePassCredentialStore> memoryHelperProvider;
    @NotNull
    private final PasswordSafeSettings settings;
    @NotNull
    private volatile CredentialStore currentProvider;

    public boolean isMemoryOnly() {
        return Intrinsics.areEqual((Object)((Object)this.settings.getProviderType()), (Object)((Object)ProviderType.MEMORY_ONLY));
    }

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Credentials value2 = this.currentProvider.get(attributes);
        if ((value2 == null || (charSequence = (CharSequence)value2.getPassword()) == null || charSequence.length() == 0) && this.memoryHelperProvider.isInitialized()) {
            Credentials credentials = ((KeePassCredentialStore)this.memoryHelperProvider.getValue()).get(attributes);
            if (credentials != null) {
                charSequence = credentials;
                Credentials it = (Credentials)charSequence;
                if (!CredentialAttributesKt.isEmpty((Credentials)it)) {
                    return it;
                }
            }
        }
        return value2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        this.currentProvider.set(attributes, credentials);
        if (attributes.isPasswordMemoryOnly()) {
            Credentials credentials2 = credentials;
            CharSequence charSequence = (CharSequence)(credentials2 != null ? credentials2.getPassword() : null);
            if (!(charSequence == null || charSequence.length() == 0)) {
                ((KeePassCredentialStore)this.memoryHelperProvider.getValue()).set(CredentialAttributesKt.toPasswordStoreable((CredentialAttributes)attributes), credentials);
                return;
            }
        }
        if (!this.memoryHelperProvider.isInitialized()) return;
        ((KeePassCredentialStore)this.memoryHelperProvider.getValue()).set(attributes, null);
    }

    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials, boolean memoryOnly) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        if (memoryOnly) {
            ((KeePassCredentialStore)this.memoryHelperProvider.getValue()).set(CredentialAttributesKt.toPasswordStoreable((CredentialAttributes)attributes), credentials);
            this.currentProvider.set(attributes, null);
        } else {
            this.set(attributes, credentials);
        }
    }

    @NotNull
    public Promise<Credentials> getAsync(@NotNull CredentialAttributes attributes) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        AsyncPromise promise$iv = new AsyncPromise();
        AppExecutorUtil.getAppExecutorService().execute(new Runnable(promise$iv, this, attributes){
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ PasswordSafeImpl this$0;
            final /* synthetic */ CredentialAttributes $attributes$inlined;
            {
                this.$promise = asyncPromise;
                this.this$0 = passwordSafeImpl;
                this.$attributes$inlined = credentialAttributes;
            }

            public final void run() {
                Credentials credentials;
                try {
                    credentials = this.this$0.get(this.$attributes$inlined);
                }
                catch (Throwable e) {
                    this.$promise.setError(e);
                    return;
                }
                Credentials result2 = credentials;
                this.$promise.setResult((Object)result2);
            }
        });
        return (Promise)promise$iv;
    }

    public void save() {
        block1: {
            CredentialStore credentialStore = this.currentProvider;
            if (!(credentialStore instanceof KeePassCredentialStore)) {
                credentialStore = null;
            }
            KeePassCredentialStore keePassCredentialStore = (KeePassCredentialStore)credentialStore;
            if (keePassCredentialStore == null) break block1;
            keePassCredentialStore.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void clearPasswords() {
        CredentialStore credentialStore;
        CredentialStoreKt.getLOG().info("Passwords cleared", (Throwable)new Error());
        try {
            if (this.memoryHelperProvider.isInitialized()) {
                ((KeePassCredentialStore)this.memoryHelperProvider.getValue()).clear();
            }
            credentialStore = this.currentProvider;
        }
        catch (Throwable throwable) {
            CredentialStore credentialStore2 = this.currentProvider;
            if (!(credentialStore2 instanceof KeePassCredentialStore)) {
                credentialStore2 = null;
            }
            KeePassCredentialStore keePassCredentialStore = (KeePassCredentialStore)credentialStore2;
            if (keePassCredentialStore == null) throw throwable;
            keePassCredentialStore.clear();
            throw throwable;
        }
        CredentialStore credentialStore3 = credentialStore;
        if (!(credentialStore instanceof KeePassCredentialStore)) {
            credentialStore3 = null;
        }
        KeePassCredentialStore keePassCredentialStore = (KeePassCredentialStore)credentialStore3;
        if (keePassCredentialStore != null) {
            keePassCredentialStore.clear();
        }
        ((PasswordSafeSettingsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(PasswordSafeSettings.TOPIC)).credentialStoreCleared();
    }

    public boolean isPasswordStoredOnlyInMemory(@NotNull CredentialAttributes attributes, @NotNull Credentials credentials) {
        Credentials it;
        CharSequence charSequence;
        CharSequence charSequence2;
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        if (this.isMemoryOnly() || (charSequence2 = (CharSequence)credentials.getPassword()) == null || charSequence2.length() == 0) {
            return true;
        }
        if (!this.memoryHelperProvider.isInitialized()) {
            return false;
        }
        Credentials credentials2 = ((KeePassCredentialStore)this.memoryHelperProvider.getValue()).get(attributes);
        return credentials2 != null ? !((charSequence = (CharSequence)(it = (Credentials)(charSequence2 = credentials2)).getPassword()) == null || charSequence.length() == 0) : false;
    }

    @Deprecated(message="Do not use it")
    private static /* synthetic */ void masterKeyProvider$annotations() {
    }

    @NotNull
    public final CredentialStore getMasterKeyProvider() {
        return this.currentProvider;
    }

    @Deprecated(message="Do not use it")
    private static /* synthetic */ void memoryProvider$annotations() {
    }

    @NotNull
    public final PasswordStorage getMemoryProvider() {
        return (PasswordStorage)this.memoryHelperProvider.getValue();
    }

    @NotNull
    public final PasswordSafeSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final CredentialStore getCurrentProvider$credential_store() {
        return this.currentProvider;
    }

    public final void setCurrentProvider$credential_store(@NotNull CredentialStore credentialStore) {
        Intrinsics.checkParameterIsNotNull((Object)credentialStore, (String)"<set-?>");
        this.currentProvider = credentialStore;
    }

    @JvmOverloads
    public PasswordSafeImpl(@NotNull PasswordSafeSettings settings, @NotNull CredentialStore currentProvider) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)currentProvider, (String)"currentProvider");
        this.settings = settings;
        this.currentProvider = currentProvider;
        this.memoryHelperProvider = LazyKt.lazy((Function0)memoryHelperProvider.1.INSTANCE);
    }

    @JvmOverloads
    public /* synthetic */ PasswordSafeImpl(PasswordSafeSettings passwordSafeSettings, CredentialStore credentialStore, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            credentialStore = PasswordSafeImplKt.computeProvider(passwordSafeSettings);
        }
        this(passwordSafeSettings, credentialStore);
    }

    @JvmOverloads
    public PasswordSafeImpl(@NotNull PasswordSafeSettings settings) {
        this(settings, null, 2, null);
    }
}

