/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.ui;

import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.jetbrains.annotations.Nullable;

public class PasswordPromptComponent {
    private JPanel myRootPanel;
    private JPanel myMessagePanel;
    private JPanel myUserPanel;
    private JPasswordField myPasswordField;
    private JCheckBox myRememberCheckBox;
    private JLabel myPasswordLabel;
    private JTextField myUserTextField;
    private JLabel myIconLabel;

    public PasswordPromptComponent(boolean memoryOnly, String message2) {
        this(memoryOnly, message2, true, null);
    }

    public PasswordPromptComponent(boolean memoryOnly, String message2, boolean showUserName, @Nullable String passwordFieldLabel) {
        this.$$$setupUI$$$();
        this.myIconLabel.setText("");
        this.myIconLabel.setIcon(Messages.getWarningIcon());
        JTextPane messageField = Messages.configureMessagePaneUi((JTextPane)new JTextPane(), (String)message2, (UIUtil.FontSize)UIUtil.FontSize.SMALL);
        this.myMessagePanel.add((Component)Messages.wrapToScrollPaneIfNeeded((JComponent)messageField, (int)0, (int)4), "Center");
        if (memoryOnly) {
            this.myRememberCheckBox.setVisible(false);
            this.myRememberCheckBox.setEnabled(false);
            this.myRememberCheckBox.setSelected(false);
        } else {
            this.myRememberCheckBox.setSelected(false);
            this.myRememberCheckBox.setToolTipText("The password will be stored between application sessions.");
        }
        this.setUserInputVisible(showUserName);
        if (passwordFieldLabel != null) {
            this.myPasswordLabel.setText(passwordFieldLabel);
        }
    }

    public JComponent getComponent() {
        return this.myRootPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myUserTextField.isEnabled() && StringUtil.isEmpty((String)this.myUserTextField.getText()) ? this.myUserTextField : this.myPasswordField;
    }

    private void setUserInputVisible(boolean visible) {
        UIUtil.setEnabled((Component)this.myUserPanel, (boolean)visible, (boolean)true);
        this.myUserPanel.setVisible(visible);
    }

    public String getUserName() {
        return this.myUserTextField.getText();
    }

    public void setUserName(String text) {
        this.myUserTextField.setText(text);
    }

    public char[] getPassword() {
        return this.myPasswordField.getPassword();
    }

    public void setPassword(String text) {
        this.myPasswordField.setText(text);
    }

    public boolean isRememberSelected() {
        return this.myRememberCheckBox.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JPasswordField jPasswordField;
        JLabel jLabel2;
        JTextField jTextField;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(15, 10, 0, 20), null, 0, 0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 1, 1, null, null, null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10), null, 0, 0, null, null));
        this.myRememberCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Remember");
        jCheckBox.setMnemonic('R');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jCheckBox, new GridConstraints(2, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myUserPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("User");
        jLabel3.setDisplayedMnemonic('U');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUserTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(200, -1), null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myPasswordLabel = jLabel2 = new JLabel();
        jLabel2.setText("Password");
        jLabel2.setDisplayedMnemonic('P');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField = new JPasswordField();
        jPasswordField.setText("");
        jPanel6.add((Component)jPasswordField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(200, -1), null));
        this.myMessagePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myIconLabel = jLabel = new JLabel();
        jLabel.setText("icon");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

