/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.SortableColumnModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.RowSorter;
import javax.swing.table.AbstractTableModel;

public abstract class PluginTableModel
extends AbstractTableModel
implements SortableColumnModel {
    protected static final String NAME = "Name";
    protected ColumnInfo[] columns;
    protected final List<IdeaPluginDescriptor> view = ContainerUtil.newArrayList();
    protected final List<IdeaPluginDescriptor> filtered = ContainerUtil.newArrayList();
    private RowSorter.SortKey myDefaultSortKey;
    private boolean mySortByStatus;
    private boolean mySortByRating;
    private boolean mySortByDownloads;
    private boolean mySortByUpdated;

    protected PluginTableModel() {
    }

    public void setSortKey(RowSorter.SortKey sortKey) {
        this.myDefaultSortKey = sortKey;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    public ColumnInfo[] getColumnInfos() {
        return this.columns;
    }

    public boolean isSortable() {
        return true;
    }

    public void setSortable(boolean aBoolean) {
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column].getName();
    }

    public IdeaPluginDescriptor getObjectAt(int row) {
        return this.view.get(row);
    }

    public Object getRowValue(int row) {
        return this.getObjectAt(row);
    }

    public RowSorter.SortKey getDefaultSortKey() {
        return this.myDefaultSortKey;
    }

    @Override
    public int getRowCount() {
        return this.view.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.columns[columnIndex].valueOf((Object)this.getObjectAt(rowIndex));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columns[columnIndex].isCellEditable((Object)this.getObjectAt(rowIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.columns[columnIndex].setValue((Object)this.getObjectAt(rowIndex), aValue);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public List<IdeaPluginDescriptorImpl> dependent(IdeaPluginDescriptorImpl plugin) {
        ArrayList<IdeaPluginDescriptorImpl> list = new ArrayList<IdeaPluginDescriptorImpl>();
        block0: for (IdeaPluginDescriptor any : this.getAllPlugins()) {
            PluginId[] dep;
            if (!(any instanceof IdeaPluginDescriptorImpl)) continue;
            for (PluginId id : dep = any.getDependentPluginIds()) {
                if (id != plugin.getPluginId()) continue;
                list.add((IdeaPluginDescriptorImpl)any);
                continue block0;
            }
        }
        return list;
    }

    public abstract void updatePluginsList(List<IdeaPluginDescriptor> var1);

    protected void filter(String filter) {
        Set search = SearchableOptionsRegistrar.getInstance().getProcessedWords(filter);
        List<IdeaPluginDescriptor> allPlugins = this.getAllPlugins();
        this.view.clear();
        this.filtered.clear();
        for (IdeaPluginDescriptor descriptor : allPlugins) {
            if (this.isPluginDescriptorAccepted(descriptor) && PluginManagerMain.isAccepted(filter, search, descriptor)) {
                this.view.add(descriptor);
                continue;
            }
            this.filtered.add(descriptor);
        }
        this.fireTableDataChanged();
    }

    public abstract int getNameColumn();

    public abstract boolean isPluginDescriptorAccepted(IdeaPluginDescriptor var1);

    public void sort() {
        try {
            Collections.sort(this.view, this.columns[this.getNameColumn()].getComparator());
            this.fireTableDataChanged();
        }
        catch (IllegalArgumentException e) {
            String message2 = e.getMessage();
            if (message2 != null && e.getMessage().contains("Comparison method violates its general contract")) {
                ColumnInfo column = this.columns[this.getNameColumn()];
                e = new IllegalArgumentException("model=" + this + " col=" + column + " cmp=" + column.getComparator(), e);
            }
            throw e;
        }
    }

    public boolean isSortByStatus() {
        return this.mySortByStatus;
    }

    public void setSortByStatus(boolean sortByStatus) {
        this.mySortByStatus = sortByStatus;
    }

    public boolean isSortByRating() {
        return this.mySortByRating;
    }

    public void setSortByRating(boolean sortByRating) {
        this.mySortByRating = sortByRating;
    }

    public boolean isSortByDownloads() {
        return this.mySortByDownloads;
    }

    public void setSortByDownloads(boolean sortByDownloads) {
        this.mySortByDownloads = sortByDownloads;
    }

    public boolean isSortByUpdated() {
        return this.mySortByUpdated;
    }

    public void setSortByUpdated(boolean sortByUpdated) {
        this.mySortByUpdated = sortByUpdated;
    }

    public List<IdeaPluginDescriptor> getAllPlugins() {
        ArrayList list = ContainerUtil.newArrayListWithCapacity((int)(this.view.size() + this.filtered.size()));
        list.addAll(this.view);
        list.addAll(this.filtered);
        return list;
    }
}

