/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.xmlb.JDOMXIncluder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PluginXmlPathResolver
implements JDOMXIncluder.PathResolver {
    private final List<File> myPluginJarFiles;

    public PluginXmlPathResolver(File[] filesInLib) {
        this.myPluginJarFiles = ContainerUtil.filter((Object[])filesInLib, file2 -> FileUtil.isJarOrZip((File)file2));
    }

    @NotNull
    public URL resolvePath(@NotNull String relativePath, @Nullable String base) {
        URL url = JDOMXIncluder.DEFAULT_PATH_RESOLVER.resolvePath(relativePath, base);
        if (URLUtil.resourceExists((URL)url) == ThreeState.NO) {
            for (File jarFile : this.myPluginJarFiles) {
                try {
                    URL entryURL = URLUtil.getJarEntryURL((File)jarFile, (String)relativePath);
                    if (URLUtil.resourceExists((URL)entryURL) != ThreeState.YES) continue;
                    return entryURL;
                }
                catch (MalformedURLException malformedURLException) {
                }
            }
        }
        return url;
    }
}

