/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseProjectTreeBuilder
extends AbstractTreeBuilder {
    protected final Project myProject;

    public BaseProjectTreeBuilder(@NotNull Project project2, @NotNull JTree tree, @NotNull DefaultTreeModel treeModel, @NotNull AbstractTreeStructure treeStructure, @Nullable Comparator<NodeDescriptor> comparator2) {
        this.init(tree, treeModel, treeStructure, comparator2, true);
        this.getUi().setClearOnHideDelay((long)Registry.intValue((String)"ide.tree.clearOnHideTime"));
        this.myProject = project2;
    }

    @NotNull
    public AsyncResult<Object> revalidateElement(Object element) {
        final AsyncResult result2 = new AsyncResult();
        if (element instanceof AbstractTreeNode) {
            AbstractTreeNode node = (AbstractTreeNode)element;
            final Object value2 = node.getValue();
            final ActionCallback callback = new ActionCallback();
            final VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)ObjectUtils.tryCast((Object)value2, PsiElement.class)));
            final FocusRequestor focusRequestor = IdeFocusManager.getInstance((Project)this.myProject).getFurtherRequestor();
            this.batch(new Progressive(){

                public void run(@NotNull ProgressIndicator indicator) {
                    Ref target = new Ref();
                    BaseProjectTreeBuilder.this._select(value2, virtualFile, false, (Condition<AbstractTreeNode>)Conditions.alwaysTrue(), callback, indicator, (Ref<Object>)target, focusRequestor, false);
                    callback.doWhenDone(() -> result2.setDone(target.get())).doWhenRejected(() -> result2.setRejected());
                }
            });
        } else {
            result2.setRejected();
        }
        return result2;
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        return ((AbstractTreeNode)nodeDescriptor).isAlwaysShowPlus();
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor.getParentDescriptor() == null || ((AbstractTreeNode)nodeDescriptor).isAlwaysExpand();
    }

    protected final void expandNodeChildren(@NotNull DefaultMutableTreeNode node) {
        NodeDescriptor userObject = (NodeDescriptor)node.getUserObject();
        if (userObject == null) {
            return;
        }
        Object element = userObject.getElement();
        VirtualFile virtualFile = BaseProjectTreeBuilder.getFileToRefresh(element);
        super.expandNodeChildren(node);
        if (virtualFile != null) {
            virtualFile.refresh(true, false);
        }
    }

    private static VirtualFile getFileToRefresh(Object element) {
        Object object = element;
        if (element instanceof AbstractTreeNode) {
            object = ((AbstractTreeNode)element).getValue();
        }
        return object instanceof PsiDirectory ? ((PsiDirectory)object).getVirtualFile() : (object instanceof PsiFile ? ((PsiFile)object).getVirtualFile() : null);
    }

    @NotNull
    private static List<AbstractTreeNode> collectChildren(@NotNull DefaultMutableTreeNode node) {
        int childCount = node.getChildCount();
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>(childCount);
        for (int i = 0; i < childCount; ++i) {
            AbstractTreeNode treeNode;
            TreeNode childAt = node.getChildAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)childAt;
            if (defaultMutableTreeNode.getUserObject() instanceof AbstractTreeNode) {
                treeNode = (AbstractTreeNode)defaultMutableTreeNode.getUserObject();
                result2.add(treeNode);
                continue;
            }
            if (!(defaultMutableTreeNode.getUserObject() instanceof FavoritesTreeNodeDescriptor)) continue;
            treeNode = ((FavoritesTreeNodeDescriptor)((Object)defaultMutableTreeNode.getUserObject())).getElement();
            result2.add(treeNode);
        }
        return result2;
    }

    @NotNull
    public ActionCallback select(Object element, VirtualFile file2, boolean requestFocus) {
        return this._select(element, file2, requestFocus, (Condition<AbstractTreeNode>)Conditions.alwaysTrue());
    }

    public ActionCallback selectInWidth(Object element, boolean requestFocus, Condition<AbstractTreeNode> nonStopCondition) {
        return this._select(element, null, requestFocus, nonStopCondition);
    }

    @NotNull
    private ActionCallback _select(Object element, VirtualFile file2, boolean requestFocus, Condition<AbstractTreeNode> nonStopCondition) {
        AbstractTreeUpdater updater = this.getUpdater();
        if (updater == null) {
            return ActionCallback.REJECTED;
        }
        ActionCallback result2 = new ActionCallback();
        FocusRequestor requestor = IdeFocusManager.getInstance((Project)this.myProject).getFurtherRequestor();
        UiActivityMonitor.getInstance().addActivity(this.myProject, (UiActivity)new UiActivity.AsyncBgOperation("projectViewSelect"), updater.getModalityState());
        this.batch(indicator -> {
            this._select(element, file2, requestFocus, nonStopCondition, result2, indicator, null, requestor, false);
            UiActivityMonitor.getInstance().removeActivity(this.myProject, (UiActivity)new UiActivity.AsyncBgOperation("projectViewSelect"));
        });
        return result2;
    }

    private void _select(Object element, VirtualFile file2, boolean requestFocus, Condition<AbstractTreeNode> nonStopCondition, ActionCallback result2, @NotNull ProgressIndicator indicator, final @Nullable Ref<Object> virtualSelectTarget, FocusRequestor focusRequestor, boolean isSecondAttempt) {
        AbstractTreeNode alreadySelected = this.alreadySelectedNode(element);
        final Runnable onDone = () -> {
            if (requestFocus && virtualSelectTarget == null && this.getUi().isReady()) {
                focusRequestor.requestFocus((Component)this.getTree(), true);
            }
            result2.setDone();
        };
        Condition condition2 = abstractTreeNode -> !result2.isProcessed() && nonStopCondition.value(abstractTreeNode);
        if (alreadySelected == null) {
            this.expandPathTo(file2, (AbstractTreeNode)this.getTreeStructure().getRootElement(), element, (Condition<AbstractTreeNode>)condition2, indicator, virtualSelectTarget).doWhenDone((Consumer)new Consumer<AbstractTreeNode>(){

                public void consume(AbstractTreeNode node) {
                    if (virtualSelectTarget == null) {
                        BaseProjectTreeBuilder.this.select(node, onDone);
                    } else {
                        onDone.run();
                    }
                }
            }).doWhenRejected(() -> {
                if (isSecondAttempt) {
                    result2.setRejected();
                } else {
                    this._select(file2, file2, requestFocus, nonStopCondition, result2, indicator, virtualSelectTarget, focusRequestor, true);
                }
            });
        } else if (virtualSelectTarget == null) {
            this.scrollTo(alreadySelected, onDone);
        } else {
            onDone.run();
        }
    }

    private AbstractTreeNode alreadySelectedNode(Object element) {
        TreePath[] selectionPaths = this.getTree().getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return null;
        }
        for (TreePath selectionPath : selectionPaths) {
            Object selected = selectionPath.getLastPathComponent();
            if (!BaseProjectTreeBuilder.elementIsEqualTo(selected, element)) continue;
            return (AbstractTreeNode)((DefaultMutableTreeNode)selected).getUserObject();
        }
        return null;
    }

    private static boolean elementIsEqualTo(Object node, Object element) {
        Object userObject;
        if (node instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)node).getUserObject()) instanceof ProjectViewNode) {
            ProjectViewNode projectViewNode = (ProjectViewNode)userObject;
            return projectViewNode.canRepresent(element);
        }
        return false;
    }

    @NotNull
    private AsyncResult<AbstractTreeNode> expandPathTo(VirtualFile file2, @NotNull AbstractTreeNode root, Object element, @NotNull Condition<AbstractTreeNode> nonStopCondition, @NotNull ProgressIndicator indicator, @Nullable Ref<Object> target) {
        AsyncResult async = new AsyncResult();
        if (root.canRepresent(element)) {
            if (target == null) {
                this.expand(root, () -> async.setDone((Object)root));
            } else {
                target.set((Object)root);
                async.setDone((Object)root);
            }
            return async;
        }
        if (root instanceof ProjectViewNode && file2 != null && !((ProjectViewNode)root).contains(file2)) {
            async.setRejected();
            return async;
        }
        if (target == null) {
            this.expand(root, () -> {
                indicator.checkCanceled();
                DefaultMutableTreeNode rootNode = this.getNodeForElement(root);
                if (rootNode != null) {
                    List<AbstractTreeNode> kids = BaseProjectTreeBuilder.collectChildren(rootNode);
                    this.expandChild(kids, 0, nonStopCondition, file2, element, (AsyncResult<AbstractTreeNode>)async, indicator, target);
                } else {
                    async.setRejected();
                }
            });
        } else if (indicator.isCanceled()) {
            async.setRejected();
        } else {
            DefaultMutableTreeNode rootNode = this.getNodeForElement(root);
            ArrayList<AbstractTreeNode> kids = new ArrayList<AbstractTreeNode>();
            if (rootNode != null && this.getTree().isExpanded(new TreePath(rootNode.getPath()))) {
                kids.addAll(BaseProjectTreeBuilder.collectChildren(rootNode));
            } else {
                List<Object> list = Arrays.asList(this.getTreeStructure().getChildElements((Object)root));
                for (Object each : list) {
                    kids.add((AbstractTreeNode)each);
                }
            }
            this.yield(() -> {
                if (this.isDisposed()) {
                    return;
                }
                this.expandChild(kids, 0, nonStopCondition, file2, element, (AsyncResult<AbstractTreeNode>)async, indicator, target);
            });
        }
        return async;
    }

    private void expandChild(@NotNull List<AbstractTreeNode> kids, int i, @NotNull Condition<AbstractTreeNode> nonStopCondition, VirtualFile file2, Object element, final @NotNull AsyncResult<AbstractTreeNode> async, final @NotNull ProgressIndicator indicator, Ref<Object> virtualSelectTarget) {
        while (i < kids.size()) {
            AbstractTreeNode eachKid = kids.get(i);
            boolean[] nodeWasCollapsed = new boolean[]{true};
            DefaultMutableTreeNode nodeForElement = this.getNodeForElement(eachKid);
            if (nodeForElement != null) {
                nodeWasCollapsed[0] = this.getTree().isCollapsed(new TreePath(nodeForElement.getPath()));
            }
            if (!nonStopCondition.value((Object)eachKid)) break;
            AsyncResult<AbstractTreeNode> result2 = this.expandPathTo(file2, eachKid, element, nonStopCondition, indicator, virtualSelectTarget);
            result2.doWhenDone((Consumer)new Consumer<AbstractTreeNode>(){

                public void consume(AbstractTreeNode abstractTreeNode) {
                    indicator.checkCanceled();
                    async.setDone((Object)abstractTreeNode);
                }
            });
            if (!result2.isProcessed()) {
                int next = i + 1;
                result2.doWhenRejected(() -> {
                    indicator.checkCanceled();
                    if (nodeWasCollapsed[0] && virtualSelectTarget == null) {
                        this.collapseChildren(eachKid, null);
                    }
                    this.expandChild(kids, next, nonStopCondition, file2, element, async, indicator, virtualSelectTarget);
                });
                return;
            }
            if (result2.isRejected()) {
                indicator.checkCanceled();
                if (nodeWasCollapsed[0] && virtualSelectTarget == null) {
                    this.collapseChildren(eachKid, null);
                }
                ++i;
                continue;
            }
            return;
        }
        async.setRejected();
    }

    protected boolean validateNode(Object child) {
        if (child == null) {
            return false;
        }
        if (child instanceof ProjectViewNode) {
            ProjectViewNode projectViewNode = (ProjectViewNode)child;
            return projectViewNode.validate();
        }
        return true;
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        return new StatusBarProgress();
    }
}

