/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryTypeServiceImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryNameAndLevelPanel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.FormBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateLibraryFromFilesDialog
extends DialogWrapper {
    private final LibraryNameAndLevelPanel myNameAndLevelPanel;
    private final ModulesComboBox myModulesComboBox;
    private final Project myProject;
    private final List<OrderRoot> myRoots;
    private final JPanel myPanel;
    private final String myDefaultName;

    public CreateLibraryFromFilesDialog(@NotNull Project project2, @NotNull List<OrderRoot> roots) {
        super(project2, true);
        this.setTitle("Create Library");
        this.myProject = project2;
        this.myRoots = roots;
        FormBuilder builder = LibraryNameAndLevelPanel.createFormBuilder();
        this.myDefaultName = LibrariesContainerFactory.createContainer(project2).suggestUniqueLibraryName(LibraryTypeServiceImpl.suggestLibraryName(roots));
        this.myNameAndLevelPanel = new LibraryNameAndLevelPanel(builder, this.myDefaultName, Arrays.asList(LibrariesContainer.LibraryLevel.values()), LibrariesContainer.LibraryLevel.PROJECT);
        this.myNameAndLevelPanel.setDefaultName(this.myDefaultName);
        this.myModulesComboBox = new ModulesComboBox();
        this.myModulesComboBox.fillModules(this.myProject);
        this.myModulesComboBox.setSelectedModule(this.findModule(roots));
        builder.addLabeledComponent("&Add to module:", (JComponent)((Object)this.myModulesComboBox));
        this.myPanel = builder.getPanel();
        this.myNameAndLevelPanel.getLibraryNameField().selectAll();
        this.myNameAndLevelPanel.getLevelComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateLibraryFromFilesDialog.this.onLevelChanged();
            }
        });
        this.myNameAndLevelPanel.getLibraryNameField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                CreateLibraryFromFilesDialog.this.updateOkAction();
            }
        });
        this.init();
    }

    private void updateOkAction() {
        this.setOKActionEnabled(!this.myNameAndLevelPanel.getLibraryName().isEmpty() || this.myNameAndLevelPanel.getLibraryLevel() == LibrariesContainer.LibraryLevel.MODULE && this.myRoots.size() == 1);
    }

    private void onLevelChanged() {
        if (this.myNameAndLevelPanel.getLibraryLevel() == LibrariesContainer.LibraryLevel.MODULE) {
            this.myNameAndLevelPanel.setDefaultName(this.myRoots.size() == 1 ? "" : this.myDefaultName);
        } else {
            this.myNameAndLevelPanel.setDefaultName(this.myDefaultName);
            if (this.myNameAndLevelPanel.getLibraryName().isEmpty()) {
                this.myNameAndLevelPanel.getLibraryNameField().setText(this.myDefaultName);
            }
        }
        this.updateOkAction();
    }

    @Nullable
    private Module findModule(List<OrderRoot> roots) {
        for (OrderRoot root : roots) {
            Module module2 = null;
            VirtualFile local = JarFileSystem.getInstance().getVirtualFileForJar(root.getFile());
            if (local != null) {
                module2 = ModuleUtil.findModuleForFile((VirtualFile)local, (Project)this.myProject);
            }
            if (module2 == null) {
                module2 = ModuleUtil.findModuleForFile((VirtualFile)root.getFile(), (Project)this.myProject);
            }
            if (module2 == null) continue;
            return module2;
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameAndLevelPanel.getLibraryNameField();
    }

    protected void doOKAction() {
        this.addLibrary();
        super.doOKAction();
    }

    private void addLibrary() {
        LibrariesContainer.LibraryLevel level = this.myNameAndLevelPanel.getLibraryLevel();
        WriteAction.run(() -> {
            Module module2 = this.myModulesComboBox.getSelectedModule();
            String libraryName = this.myNameAndLevelPanel.getLibraryName();
            if (level == LibrariesContainer.LibraryLevel.MODULE) {
                ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
                LibrariesContainerFactory.createContainer(modifiableModel).createLibrary(libraryName, level, this.myRoots);
                modifiableModel.commit();
            } else {
                Library library = LibrariesContainerFactory.createContainer(this.myProject).createLibrary(libraryName, level, this.myRoots);
                if (module2 != null) {
                    ModuleRootModificationUtil.addDependency((Module)module2, (Library)library);
                }
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }
}

