/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MarkExcludeRootAction
extends MarkRootActionBase {
    public MarkExcludeRootAction() {
        super(null, null, AllIcons.Modules.ExcludeRoot);
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (Registry.is((String)"ide.hide.excluded.files")) {
            String message2 = files.length == 1 ? FileUtil.toSystemDependentName((String)files[0].getPath()) : files.length + " selected files";
            int rc = Messages.showOkCancelDialog((Project)((Project)e.getData(CommonDataKeys.PROJECT)), (String)this.getPromptText(message2), (String)"Mark as Excluded", (Icon)Messages.getQuestionIcon());
            if (rc != 0) {
                return;
            }
        }
        super.actionPerformed(e);
    }

    protected String getPromptText(String message2) {
        return "Are you sure you would like to exclude " + message2 + " from the project?\nYou can restore excluded directories later using the Project Structure dialog.";
    }

    @Override
    protected void modifyRoots(@NotNull VirtualFile vFile, @NotNull ContentEntry entry) {
        entry.addExcludeFolder(vFile);
    }

    @Override
    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module2) {
        ModuleFileIndex index = ModuleRootManager.getInstance((Module)module2).getFileIndex();
        return selection.mySelectedDirectories.stream().allMatch(file2 -> index.isInContent(file2));
    }
}

