/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MarkRootActionBase
extends DumbAwareAction {
    public MarkRootActionBase() {
    }

    public MarkRootActionBase(@Nullable String text) {
        super(text);
    }

    public MarkRootActionBase(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Module module2 = MarkRootActionBase.getModule(e, files);
        if (module2 == null) {
            return;
        }
        this.modifyRoots(e, module2, files);
    }

    protected void modifyRoots(@NotNull AnActionEvent e, @NotNull Module module2, @NotNull VirtualFile[] files) {
        ModifiableRootModel model = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
        for (VirtualFile file2 : files) {
            SourceFolder[] sourceFolders;
            ContentEntry entry = MarkRootActionBase.findContentEntry((ModuleRootModel)model, file2);
            if (entry == null) continue;
            for (SourceFolder sourceFolder : sourceFolders = entry.getSourceFolders()) {
                if (!Comparing.equal((Object)sourceFolder.getFile(), (Object)file2)) continue;
                entry.removeSourceFolder(sourceFolder);
                break;
            }
            this.modifyRoots(file2, entry);
        }
        MarkRootActionBase.commitModel(module2, model);
    }

    static void commitModel(@NotNull Module module2, ModifiableRootModel model) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            model.commit();
            module2.getProject().save();
        });
    }

    protected abstract void modifyRoots(VirtualFile var1, ContentEntry var2);

    @Nullable
    public static ContentEntry findContentEntry(@NotNull ModuleRootModel model, @NotNull VirtualFile vFile) {
        ContentEntry[] contentEntries;
        for (ContentEntry contentEntry : contentEntries = model.getContentEntries()) {
            VirtualFile contentEntryFile = contentEntry.getFile();
            if (contentEntryFile == null || !VfsUtilCore.isAncestor((VirtualFile)contentEntryFile, (VirtualFile)vFile, (boolean)false)) continue;
            return contentEntry;
        }
        return null;
    }

    public void update(AnActionEvent e) {
        RootsSelection selection = MarkRootActionBase.getSelection(e);
        this.doUpdate(e, selection.myModule, selection);
    }

    protected void doUpdate(@NotNull AnActionEvent e, @Nullable Module module2, @NotNull RootsSelection selection) {
        boolean enabled = module2 != null && (!selection.mySelectedRoots.isEmpty() || !selection.mySelectedDirectories.isEmpty()) && selection.mySelectedExcludeRoots.isEmpty() && this.isEnabled(selection, module2);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    protected abstract boolean isEnabled(@NotNull RootsSelection var1, @NotNull Module var2);

    protected static RootsSelection getSelection(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Module module2 = MarkRootActionBase.getModule(e, files);
        if (module2 == null) {
            return RootsSelection.EMPTY;
        }
        RootsSelection selection = new RootsSelection(module2);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module2.getProject()).getFileIndex();
        for (VirtualFile file2 : files) {
            if (!file2.isDirectory()) {
                return RootsSelection.EMPTY;
            }
            ExcludeFolder excludeFolder = ProjectRootsUtil.findExcludeFolder(module2, file2);
            if (excludeFolder != null) {
                selection.mySelectedExcludeRoots.add(excludeFolder);
                continue;
            }
            SourceFolder folder = ProjectRootsUtil.findSourceFolder(module2, file2);
            if (folder != null) {
                selection.mySelectedRoots.add(folder);
                continue;
            }
            selection.mySelectedDirectories.add(file2);
            if (!fileIndex.isInSourceContent(file2)) continue;
            selection.myHaveSelectedFilesUnderSourceRoots = true;
        }
        return selection;
    }

    @Nullable
    static Module getModule(@NotNull AnActionEvent e, @Nullable VirtualFile[] files) {
        if (files == null) {
            return null;
        }
        Module module2 = (Module)e.getData(LangDataKeys.MODULE);
        if (module2 == null) {
            module2 = MarkRootActionBase.findParentModule(e.getProject(), files);
        }
        return module2;
    }

    @Nullable
    private static Module findParentModule(@Nullable Project project2, @NotNull VirtualFile[] files) {
        if (project2 == null) {
            return null;
        }
        Module result2 = null;
        DirectoryIndex index = DirectoryIndex.getInstance(project2);
        for (VirtualFile file2 : files) {
            Module module2 = index.getInfoForFile(file2).getModule();
            if (module2 == null) {
                return null;
            }
            if (result2 == null) {
                result2 = module2;
                continue;
            }
            if (result2.equals(module2)) continue;
            return null;
        }
        return result2;
    }

    public static class RootsSelection {
        public static final RootsSelection EMPTY = new RootsSelection(null);
        public final Module myModule;
        public List<SourceFolder> mySelectedRoots = new ArrayList<SourceFolder>();
        public List<ExcludeFolder> mySelectedExcludeRoots = new ArrayList<ExcludeFolder>();
        public List<VirtualFile> mySelectedDirectories = new ArrayList<VirtualFile>();
        public boolean myHaveSelectedFilesUnderSourceRoots;

        public RootsSelection(Module module2) {
            this.myModule = module2;
        }
    }
}

