/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnmarkRootAction
extends MarkRootActionBase {
    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @Nullable Module module2, @NotNull MarkRootActionBase.RootsSelection selection) {
        if (!Registry.is((String)"ide.hide.excluded.files") && !selection.mySelectedExcludeRoots.isEmpty() && selection.mySelectedDirectories.isEmpty() && selection.mySelectedRoots.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(true);
            e.getPresentation().setText(LangBundle.message("mark.as.unmark.excluded", new Object[0]));
            return;
        }
        super.doUpdate(e, module2, selection);
        String text = this.getActionText(e, module2, selection);
        if (text != null) {
            e.getPresentation().setText(text);
        }
    }

    @Nullable
    protected String getActionText(@NotNull AnActionEvent e, @Nullable Module module2, @NotNull MarkRootActionBase.RootsSelection selection) {
        Set<ModuleSourceRootEditHandler<?>> selectedRootHandlers = UnmarkRootAction.getHandlersForSelectedRoots(selection);
        if (!selectedRootHandlers.isEmpty()) {
            if (selectedRootHandlers.size() == 1) {
                ModuleSourceRootEditHandler<?> handler2 = selectedRootHandlers.iterator().next();
                return LangBundle.message("mark.as.unmark", StringUtil.pluralize((String)handler2.getFullRootTypeName(), (int)selection.mySelectedRoots.size()));
            }
            return LangBundle.message("mark.as.unmark.several", new Object[0]);
        }
        return null;
    }

    @NotNull
    private static Set<ModuleSourceRootEditHandler<?>> getHandlersForSelectedRoots(@NotNull MarkRootActionBase.RootsSelection selection) {
        HashSet selectedRootHandlers = new HashSet();
        for (SourceFolder root : selection.mySelectedRoots) {
            ContainerUtil.addIfNotNull((Collection)selectedRootHandlers, ModuleSourceRootEditHandler.getEditHandler(root.getRootType()));
        }
        return selectedRootHandlers;
    }

    @Override
    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module2) {
        return selection.mySelectedDirectories.isEmpty() && !UnmarkRootAction.getHandlersForSelectedRoots(selection).isEmpty();
    }

    @Override
    protected void modifyRoots(@NotNull VirtualFile file2, @NotNull ContentEntry entry) {
        for (ExcludeFolder excludeFolder : entry.getExcludeFolders()) {
            if (!file2.equals(excludeFolder.getFile())) continue;
            entry.removeExcludeFolder(excludeFolder);
            break;
        }
    }
}

