/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModuleGroup {
    public static final DataKey<ModuleGroup[]> ARRAY_DATA_KEY = DataKey.create((String)"moduleGroup.array");
    private final List<String> myGroupPath;

    public ModuleGroup(@NotNull List<String> groupPath) {
        this.myGroupPath = groupPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleGroup)) {
            return false;
        }
        return this.myGroupPath.equals(((ModuleGroup)o).myGroupPath);
    }

    public int hashCode() {
        return this.myGroupPath.hashCode();
    }

    public String[] getGroupPath() {
        return ArrayUtil.toStringArray(this.myGroupPath);
    }

    public List<String> getGroupPathList() {
        return this.myGroupPath;
    }

    @NotNull
    public Collection<Module> modulesInGroup(Project project2, boolean recursively) {
        return this.modulesInGroup(ModuleGrouper.instanceFor((Project)project2), recursively);
    }

    @NotNull
    public Collection<Module> modulesInGroup(ModuleGrouper grouper, boolean recursively) {
        ArrayList<Module> result2 = new ArrayList<Module>();
        for (Module module2 : grouper.getAllModules()) {
            List group = grouper.getGroupPath(module2);
            if (!this.myGroupPath.equals(group) && (!recursively || !ModuleGroup.isChild(this.myGroupPath, group))) continue;
            result2.add(module2);
        }
        return result2;
    }

    @NotNull
    public Collection<ModuleGroup> childGroups(ModuleGrouper grouper) {
        THashSet result2 = new THashSet();
        for (Module module2 : grouper.getAllModules()) {
            List group = grouper.getGroupPath(module2);
            if (!ModuleGroup.isChild(this.myGroupPath, group)) continue;
            List directChild = ContainerUtil.append(this.myGroupPath, (Object[])new String[]{(String)group.get(this.myGroupPath.size())});
            result2.add(new ModuleGroup(directChild));
        }
        return result2;
    }

    private static boolean isChild(List<String> parent, List<String> descendant) {
        return descendant.size() > parent.size() && descendant.subList(0, parent.size()).equals(parent);
    }

    public String presentableText() {
        return "'" + this.myGroupPath.get(this.myGroupPath.size() - 1) + "'";
    }

    public String toString() {
        return this.myGroupPath.get(this.myGroupPath.size() - 1);
    }
}

