/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.List;
import java.util.Map;

public class ModuleGroupUtil {
    private ModuleGroupUtil() {
    }

    public static <T> T buildModuleGroupPath(ModuleGroup group, T parentNode, Map<ModuleGroup, T> map2, Consumer<ParentChildRelation<T>> insertNode, Function<ModuleGroup, T> createNewNode) {
        List<String> groupPath = group.getGroupPathList();
        for (int i2 = 0; i2 < groupPath.size(); ++i2) {
            ModuleGroup moduleGroup = new ModuleGroup(groupPath.subList(0, i2 + 1));
            Object moduleGroupNode = map2.get(moduleGroup);
            if (moduleGroupNode == null) {
                moduleGroupNode = createNewNode.fun((Object)moduleGroup);
                map2.put(moduleGroup, moduleGroupNode);
                insertNode.consume(new ParentChildRelation<T>(parentNode, moduleGroupNode));
            }
            parentNode = moduleGroupNode;
        }
        return parentNode;
    }

    public static <T> T updateModuleGroupPath(ModuleGroup group, T parentNode, Function<ModuleGroup, T> needToCreateNode, Consumer<ParentChildRelation<T>> insertNode, Function<ModuleGroup, T> createNewNode) {
        List<String> groupPath = group.getGroupPathList();
        for (int i2 = 0; i2 < groupPath.size(); ++i2) {
            ModuleGroup moduleGroup = new ModuleGroup(groupPath.subList(0, i2 + 1));
            Object moduleGroupNode = needToCreateNode.fun((Object)moduleGroup);
            if (moduleGroupNode == null) {
                moduleGroupNode = createNewNode.fun((Object)moduleGroup);
                insertNode.consume(new ParentChildRelation<Object>(parentNode, moduleGroupNode));
            }
            parentNode = moduleGroupNode;
        }
        return parentNode;
    }

    public static class ParentChildRelation<T> {
        private final T myParent;
        private final T myChild;

        public ParentChildRelation(T parent, T child) {
            this.myParent = parent;
            this.myChild = child;
        }

        public T getParent() {
            return this.myParent;
        }

        public T getChild() {
            return this.myChild;
        }
    }
}

