/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.actions.MoveModulesToGroupAction;
import com.intellij.ide.projectView.actions.MoveModulesToSubGroupAction;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveModuleToGroup
extends ActionGroup {
    private final ModuleGroup myModuleGroup;

    public MoveModuleToGroup(ModuleGroup moduleGroup) {
        this.myModuleGroup = moduleGroup;
        this.setPopup(true);
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        boolean active = project2 != null && modules != null && modules.length != 0;
        Presentation presentation = e.getPresentation();
        presentation.setVisible(active);
        presentation.setText(this.myModuleGroup.presentableText());
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            return EMPTY_ARRAY;
        }
        Project project2 = MoveModuleToGroup.getEventProject((AnActionEvent)e);
        if (project2 == null) {
            return EMPTY_ARRAY;
        }
        ModifiableModuleModel modifiableModuleModel = (ModifiableModuleModel)LangDataKeys.MODIFIABLE_MODULE_MODEL.getData(e.getDataContext());
        ArrayList<MoveModulesToGroupAction> result2 = new ArrayList<MoveModulesToGroupAction>();
        result2.add(new MoveModulesToGroupAction(this.myModuleGroup, IdeBundle.message((String)"action.move.module.to.this.group", (Object[])new Object[0])));
        result2.add(new MoveModulesToSubGroupAction(this.myModuleGroup));
        result2.add((MoveModulesToGroupAction)Separator.getInstance());
        ModuleGrouper grouper = ModuleGrouper.instanceFor((Project)project2, (ModifiableModuleModel)modifiableModuleModel);
        result2.addAll(this.myModuleGroup.childGroups(grouper).stream().sorted((moduleGroup1, moduleGroup2) -> {
            assert (moduleGroup1.getGroupPath().length == moduleGroup2.getGroupPath().length);
            return moduleGroup1.toString().compareToIgnoreCase(moduleGroup2.toString());
        }).map(MoveModuleToGroup::new).collect(Collectors.toList()));
        return result2.toArray(new AnAction[result2.size()]);
    }
}

