/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.ProjectViewNestingRulesProvider;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.NestingTreeNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NestingTreeStructureProvider
implements TreeStructureProvider,
DumbAware {
    private static ExtensionPointName<ProjectViewNestingRulesProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.projectViewNestingRulesProvider");
    private static final Logger LOG = Logger.getInstance(NestingTreeStructureProvider.class);
    private Set<NestingRule> myNestingRules;

    @NotNull
    private Collection<NestingRule> getNestingRules() {
        if (this.myNestingRules == null) {
            this.myNestingRules = new THashSet();
            final MultiMap childToParentSuffix = new MultiMap();
            final MultiMap parentToChildSuffix = new MultiMap();
            ProjectViewNestingRulesProvider.Consumer consumer2 = new ProjectViewNestingRulesProvider.Consumer(){

                public void addNestingRule(@NotNull String parentFileSuffix, @NotNull String childFileSuffix) {
                    LOG.assertTrue(!parentFileSuffix.isEmpty() && !childFileSuffix.isEmpty(), (Object)"file suffix must not be empty");
                    LOG.assertTrue(!parentFileSuffix.equals(childFileSuffix), (Object)("parent and child suffixes must be different: " + parentFileSuffix));
                    NestingTreeStructureProvider.this.myNestingRules.add(new NestingRule(parentFileSuffix, childFileSuffix));
                    childToParentSuffix.putValue((Object)childFileSuffix, (Object)parentFileSuffix);
                    parentToChildSuffix.putValue((Object)parentFileSuffix, (Object)childFileSuffix);
                    for (String s : parentToChildSuffix.get((Object)childFileSuffix)) {
                        NestingTreeStructureProvider.this.myNestingRules.add(new NestingRule(parentFileSuffix, s));
                        parentToChildSuffix.putValue((Object)parentFileSuffix, (Object)s);
                        childToParentSuffix.putValue((Object)s, (Object)parentFileSuffix);
                    }
                    for (String s : childToParentSuffix.get((Object)parentFileSuffix)) {
                        NestingTreeStructureProvider.this.myNestingRules.add(new NestingRule(s, childFileSuffix));
                        parentToChildSuffix.putValue((Object)s, (Object)childFileSuffix);
                        childToParentSuffix.putValue((Object)childFileSuffix, (Object)s);
                    }
                }
            };
            for (ProjectViewNestingRulesProvider provider2 : (ProjectViewNestingRulesProvider[])EP_NAME.getExtensions()) {
                provider2.addFileNestingRules(consumer2);
            }
        }
        return this.myNestingRules;
    }

    @NotNull
    private static Collection<NestingRule> getNestingRulesStatic(@NotNull Project project2) {
        for (TreeStructureProvider provider2 : (TreeStructureProvider[])Extensions.getExtensions((ExtensionPointName)TreeStructureProvider.EP_NAME, (AreaInstance)project2)) {
            if (!(provider2 instanceof NestingTreeStructureProvider)) continue;
            return ((NestingTreeStructureProvider)provider2).getNestingRules();
        }
        return Collections.emptyList();
    }

    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children2, ViewSettings settings) {
        if (!(parent instanceof PsiDirectoryNode)) {
            return children2;
        }
        Collection<NestingRule> rules = this.getNestingRules();
        if (rules.isEmpty()) {
            return children2;
        }
        MultiMap<PsiFileNode, PsiFileNode> parentToChildren = NestingTreeStructureProvider.calcParentToChildren(children2, rules);
        if (parentToChildren.isEmpty()) {
            return children2;
        }
        ArrayList<AbstractTreeNode> newChildren = new ArrayList<AbstractTreeNode>(children2.size() - parentToChildren.size());
        THashSet childrenToMoveDown = new THashSet(parentToChildren.values());
        for (AbstractTreeNode node : children2) {
            if (!(node instanceof PsiFileNode)) {
                newChildren.add(node);
                continue;
            }
            if (childrenToMoveDown.contains(node)) continue;
            Collection childrenOfThisFile = parentToChildren.get((Object)((PsiFileNode)node));
            if (childrenOfThisFile.isEmpty()) {
                newChildren.add(node);
                continue;
            }
            newChildren.add((AbstractTreeNode)new NestingTreeNode((PsiFileNode)node, childrenOfThisFile));
        }
        return newChildren;
    }

    public static Collection<ChildFileInfo> getFilesShownAsChildrenInProjectView(@NotNull Project project2, @NotNull VirtualFile parentFile) {
        LOG.assertTrue(!parentFile.isDirectory());
        VirtualFile dir = parentFile.getParent();
        if (dir == null) {
            return Collections.emptyList();
        }
        Collection<NestingRule> rules = NestingTreeStructureProvider.getNestingRulesStatic(project2);
        if (rules.isEmpty()) {
            return Collections.emptyList();
        }
        VirtualFile[] children2 = dir.getChildren();
        if (children2.length <= 1) {
            return Collections.emptyList();
        }
        Collection<NestingRule> rulesWhereItCanBeParent = NestingTreeStructureProvider.filterRules(rules, parentFile.getName(), true);
        if (rulesWhereItCanBeParent.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<NestingRule> rulesWhereItCanBeChild = NestingTreeStructureProvider.filterRules(rules, parentFile.getName(), false);
        SmartList result2 = new SmartList();
        for (VirtualFile child : children2) {
            String baseName;
            Couple<Boolean> c;
            String childName;
            if (child.isDirectory() || child.equals(parentFile)) continue;
            for (NestingRule rule : rulesWhereItCanBeChild) {
                childName = child.getName();
                c = NestingTreeStructureProvider.checkMatchingAsParentOrChild(rule, childName);
                boolean matchesParent = (Boolean)c.first;
                if (!matchesParent) continue;
                baseName = childName.substring(0, childName.length() - rule.myParentFileSuffix.length());
                if (!parentFile.getName().equals(baseName + rule.myChildFileSuffix)) continue;
                return Collections.emptyList();
            }
            for (NestingRule rule : rulesWhereItCanBeParent) {
                childName = child.getName();
                c = NestingTreeStructureProvider.checkMatchingAsParentOrChild(rule, childName);
                boolean matchesChild = (Boolean)c.second;
                if (!matchesChild) continue;
                baseName = childName.substring(0, childName.length() - rule.myChildFileSuffix.length());
                if (!parentFile.getName().equals(baseName + rule.myParentFileSuffix)) continue;
                result2.add((Object)new ChildFileInfo(child, baseName));
            }
        }
        return result2;
    }

    @NotNull
    private static Collection<NestingRule> filterRules(@NotNull Collection<NestingRule> rules, @NotNull String fileName, boolean parentNotChild) {
        SmartList result2 = new SmartList();
        for (NestingRule rule : rules) {
            Couple<Boolean> c = NestingTreeStructureProvider.checkMatchingAsParentOrChild(rule, fileName);
            boolean matchesParent = (Boolean)c.first;
            boolean matchesChild = (Boolean)c.second;
            if (!matchesChild && !matchesParent) continue;
            if (matchesParent && parentNotChild) {
                result2.add((Object)rule);
            }
            if (!matchesChild || parentNotChild) continue;
            result2.add((Object)rule);
        }
        return result2;
    }

    @NotNull
    private static MultiMap<PsiFileNode, PsiFileNode> calcParentToChildren(@NotNull Collection<AbstractTreeNode> nodes, @NotNull Collection<NestingRule> rules) {
        MultiMap parentToChildren = null;
        THashSet allChildNodes = null;
        THashMap baseNameAndRuleToEdge = null;
        for (AbstractTreeNode node : nodes) {
            PsiFile file2;
            if (!(node instanceof PsiFileNode) || (file2 = (PsiFile)((PsiFileNode)node).getValue()) == null) continue;
            for (NestingRule rule : rules) {
                Edge<PsiFileNode> edge;
                String baseName;
                String fileName = file2.getName();
                Couple<Boolean> c = NestingTreeStructureProvider.checkMatchingAsParentOrChild(rule, fileName);
                boolean matchesParent = (Boolean)c.first;
                boolean matchesChild = (Boolean)c.second;
                if (!matchesChild && !matchesParent) continue;
                if (baseNameAndRuleToEdge == null) {
                    baseNameAndRuleToEdge = new THashMap();
                    parentToChildren = new MultiMap();
                    allChildNodes = new THashSet();
                }
                if (matchesParent) {
                    baseName = fileName.substring(0, fileName.length() - rule.myParentFileSuffix.length());
                    edge = NestingTreeStructureProvider.getOrCreateEdge((Map<Pair<String, NestingRule>, Edge<PsiFileNode>>)baseNameAndRuleToEdge, baseName, rule);
                    ((Edge)edge).from = (Object)((PsiFileNode)node);
                    NestingTreeStructureProvider.updateInfoIfEdgeComplete((MultiMap<PsiFileNode, PsiFileNode>)parentToChildren, (Set<PsiFileNode>)allChildNodes, edge);
                }
                if (!matchesChild) continue;
                baseName = fileName.substring(0, fileName.length() - rule.myChildFileSuffix.length());
                edge = NestingTreeStructureProvider.getOrCreateEdge((Map<Pair<String, NestingRule>, Edge<PsiFileNode>>)baseNameAndRuleToEdge, baseName, rule);
                ((Edge)edge).to = (Object)((PsiFileNode)node);
                NestingTreeStructureProvider.updateInfoIfEdgeComplete((MultiMap<PsiFileNode, PsiFileNode>)parentToChildren, (Set<PsiFileNode>)allChildNodes, edge);
            }
        }
        return parentToChildren == null ? MultiMap.empty() : parentToChildren;
    }

    private static Couple<Boolean> checkMatchingAsParentOrChild(@NotNull NestingRule rule, @NotNull String fileName) {
        boolean matchesChild;
        boolean matchesParent = !fileName.equals(rule.myParentFileSuffix) && fileName.endsWith(rule.myParentFileSuffix);
        boolean bl = matchesChild = !fileName.equals(rule.myChildFileSuffix) && fileName.endsWith(rule.myChildFileSuffix);
        if (matchesParent && matchesChild) {
            if (rule.myParentFileSuffix.length() > rule.myChildFileSuffix.length()) {
                matchesChild = false;
            } else {
                matchesParent = false;
            }
        }
        return Couple.of((Object)matchesParent, (Object)matchesChild);
    }

    @NotNull
    private static Edge<PsiFileNode> getOrCreateEdge(@NotNull Map<Pair<String, NestingRule>, Edge<PsiFileNode>> baseNameAndRuleToEdge, @NotNull String baseName, @NotNull NestingRule rule) {
        Pair baseNameAndRule = Pair.create((Object)baseName, (Object)rule);
        Edge<PsiFileNode> edge = baseNameAndRuleToEdge.get(baseNameAndRule);
        if (edge == null) {
            edge = new Edge();
            baseNameAndRuleToEdge.put((Pair<String, NestingRule>)baseNameAndRule, edge);
        }
        return edge;
    }

    private static void updateInfoIfEdgeComplete(@NotNull MultiMap<PsiFileNode, PsiFileNode> parentToChildren, @NotNull Set<PsiFileNode> allChildNodes, @NotNull Edge<PsiFileNode> edge) {
        if (((Edge)edge).from != null && ((Edge)edge).to != null) {
            allChildNodes.add((PsiFileNode)((Object)((Edge)edge).to));
            parentToChildren.remove(((Edge)edge).to);
            if (!allChildNodes.contains(((Edge)edge).from)) {
                parentToChildren.putValue(((Edge)edge).from, ((Edge)edge).to);
            }
        }
    }

    public static class ChildFileInfo {
        @NotNull
        public final VirtualFile file;
        @NotNull
        public final String namePartCommonWithParentFile;

        public ChildFileInfo(@NotNull VirtualFile file2, @NotNull String namePartCommonWithParentFile) {
            this.file = file2;
            this.namePartCommonWithParentFile = namePartCommonWithParentFile;
        }
    }

    private static class Edge<T> {
        @Nullable
        private T from;
        @Nullable
        private T to;

        private Edge() {
        }
    }

    private static class NestingRule {
        @NotNull
        private final String myParentFileSuffix;
        @NotNull
        private final String myChildFileSuffix;

        public NestingRule(@NotNull String parentFileSuffix, @NotNull String childFileSuffix) {
            this.myParentFileSuffix = parentFileSuffix;
            this.myChildFileSuffix = childFileSuffix;
        }

        public String toString() {
            return this.myParentFileSuffix + "->" + this.myChildFileSuffix;
        }

        public boolean equals(Object o) {
            return o instanceof NestingRule && this.myParentFileSuffix.equals(((NestingRule)o).myParentFileSuffix) && this.myChildFileSuffix.equals(((NestingRule)o).myChildFileSuffix);
        }

        public int hashCode() {
            return this.myParentFileSuffix.hashCode() + 239 * this.myChildFileSuffix.hashCode();
        }
    }
}

