/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractModuleNode;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.PackageViewLibrariesNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageViewModuleNode
extends AbstractModuleNode {
    public PackageViewModuleNode(Project project2, Module value2, ViewSettings viewSettings) {
        super(project2, value2, viewSettings);
    }

    public PackageViewModuleNode(Project project2, Object value2, ViewSettings viewSettings) {
        this(project2, (Module)value2, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        Collection<AbstractTreeNode> result2 = PackageUtil.createPackageViewChildrenOnFiles(Arrays.asList(ModuleRootManager.getInstance((Module)((Module)this.getValue())).getSourceRoots()), this.myProject, this.getSettings(), (Module)this.getValue(), false);
        if (this.getSettings().isShowLibraryContents()) {
            result2.add((AbstractTreeNode)new PackageViewLibrariesNode(this.getProject(), (Module)this.getValue(), this.getSettings()));
        }
        return result2;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        Module module2 = (Module)this.getValue();
        return module2 != null && !module2.isDisposed() && (ModuleUtilCore.moduleContainsFile((Module)module2, (VirtualFile)file2, (boolean)false) || ModuleUtilCore.moduleContainsFile((Module)module2, (VirtualFile)file2, (boolean)true));
    }

    public boolean validate() {
        return this.getValue() != null;
    }

    public boolean someChildContainsFile(VirtualFile file2) {
        return true;
    }

    @Override
    public void update(PresentationData presentation) {
        super.update(presentation);
        Icon icon = this.getModuleIcon();
        if (icon != null) {
            presentation.setIcon(icon);
        }
    }

    @Nullable
    private Icon getModuleIcon() {
        Module module2 = (Module)this.getValue();
        if (module2 != null && !module2.isDisposed()) {
            VirtualFile virtualFile = module2.getModuleFile();
            Icon icon = null;
            if (virtualFile != null) {
                icon = IconUtil.getIcon((VirtualFile)virtualFile, (int)0, (Project)module2.getProject());
            }
            if (icon == null) {
                icon = ModuleType.get((Module)module2).getIcon();
            }
            return icon;
        }
        return null;
    }
}

