/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableWithText;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyntheticLibraryElementNode
extends ProjectViewNode<SyntheticLibrary>
implements NavigatableWithText {
    public SyntheticLibraryElementNode(@NotNull Project project2, @NotNull SyntheticLibrary library, ViewSettings settings) {
        super(project2, (Object)library, settings);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        SyntheticLibrary library = this.getLibrary();
        return VfsUtilCore.isUnder((VirtualFile)file2, (Set)ContainerUtil.newHashSet(library.getSourceRoots()));
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        ArrayList<AbstractTreeNode> children2 = new ArrayList<AbstractTreeNode>();
        SyntheticLibrary library = this.getLibrary();
        Project project2 = Objects.requireNonNull(this.getProject());
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        for (VirtualFile file2 : library.getSourceRoots()) {
            if (!file2.isValid()) continue;
            if (file2.isDirectory()) {
                PsiDirectory psiDir = psiManager.findDirectory(file2);
                if (psiDir == null) continue;
                children2.add((AbstractTreeNode)new PsiDirectoryNode(project2, psiDir, this.getSettings()));
                continue;
            }
            PsiFile psiFile = psiManager.findFile(file2);
            if (psiFile == null) continue;
            children2.add((AbstractTreeNode)new PsiFileNode(project2, psiFile, this.getSettings()));
        }
        return children2;
    }

    public String getName() {
        SyntheticLibrary library = this.getLibrary();
        return ((ItemPresentation)library).getPresentableText();
    }

    @NotNull
    private SyntheticLibrary getLibrary() {
        return (SyntheticLibrary)Objects.requireNonNull(this.getValue());
    }

    protected void update(PresentationData presentation) {
        presentation.updateFrom((ItemPresentation)this.getLibrary());
    }

    @Nullable
    public String getNavigateActionText(boolean focusEditor) {
        NavigatableWithText navigatable = (NavigatableWithText)ObjectUtils.tryCast((Object)this.getLibrary(), NavigatableWithText.class);
        return navigatable != null ? navigatable.getNavigateActionText(focusEditor) : null;
    }

    public boolean canNavigate() {
        Navigatable navigatable = (Navigatable)ObjectUtils.tryCast((Object)this.getLibrary(), Navigatable.class);
        return navigatable != null && navigatable.canNavigate();
    }

    public boolean canNavigateToSource() {
        Navigatable navigatable = (Navigatable)ObjectUtils.tryCast((Object)this.getLibrary(), Navigatable.class);
        return navigatable != null && navigatable.canNavigateToSource();
    }

    public void navigate(boolean requestFocus) {
        Navigatable navigatable = (Navigatable)ObjectUtils.tryCast((Object)this.getLibrary(), Navigatable.class);
        if (navigatable != null) {
            navigatable.navigate(requestFocus);
        }
    }
}

