/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RootType {
    public static final ExtensionPointName<RootType> ROOT_EP = ExtensionPointName.create((String)"com.intellij.scratch.rootType");
    private final String myId;
    private final String myDisplayName;

    @NotNull
    public static RootType[] getAllRootIds() {
        return (RootType[])Extensions.getExtensions(ROOT_EP);
    }

    @NotNull
    public static RootType findById(@NotNull String id) {
        for (RootType type2 : RootType.getAllRootIds()) {
            if (!id.equals(type2.getId())) continue;
            return type2;
        }
        throw new AssertionError((Object)id);
    }

    @NotNull
    public static <T extends RootType> T findByClass(Class<T> aClass) {
        return (T)((RootType)Extensions.findExtension(ROOT_EP, aClass));
    }

    protected RootType(@NotNull String id, @Nullable String displayName) {
        this.myId = id;
        this.myDisplayName = displayName;
    }

    @NotNull
    public final String getId() {
        return this.myId;
    }

    @Nullable
    public final String getDisplayName() {
        return this.myDisplayName;
    }

    public boolean isHidden() {
        return StringUtil.isEmpty((String)this.myDisplayName);
    }

    public boolean containsFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        ScratchFileService service = ScratchFileService.getInstance();
        return service != null && service.getRootType(file2) == this;
    }

    @Nullable
    public Language substituteLanguage(@NotNull Project project2, @NotNull VirtualFile file2) {
        return null;
    }

    @Nullable
    public Icon substituteIcon(@NotNull Project project2, @NotNull VirtualFile file2) {
        Language language = this.substituteLanguage(project2, file2);
        FileType fileType = LanguageUtil.getLanguageFileType((Language)language);
        if (fileType == null) {
            fileType = ScratchUtil.getFileTypeFromName(file2);
        }
        return fileType != null ? fileType.getIcon() : null;
    }

    @Nullable
    public String substituteName(@NotNull Project project2, @NotNull VirtualFile file2) {
        return null;
    }

    public VirtualFile findFile(@Nullable Project project2, @NotNull String pathName, ScratchFileService.Option option) throws IOException {
        return ScratchFileService.getInstance().findFile(this, pathName, option);
    }

    public void fileOpened(@NotNull VirtualFile file2, @NotNull FileEditorManager source) {
    }

    public void fileClosed(@NotNull VirtualFile file2, @NotNull FileEditorManager source) {
    }

    public boolean isIgnored(@NotNull Project project2, @NotNull VirtualFile element) {
        return false;
    }

    public void registerTreeUpdater(@NotNull Project project2, @NotNull AbstractTreeBuilder builder) {
    }
}

