/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewPsiTreeChangeListener;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchProjectViewPane
extends ProjectViewPane {
    public static final String ID = "Scratches";

    public ScratchProjectViewPane(Project project2) {
        super(project2);
    }

    @Override
    public String getTitle() {
        return ID;
    }

    @Override
    public Icon getIcon() {
        return super.getIcon();
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new MyTreeStructure(this.myProject);
    }

    @Override
    public int getWeight() {
        return 11;
    }

    @Override
    @NotNull
    protected BaseProjectTreeBuilder createBuilder(DefaultTreeModel treeModel) {
        ProjectTreeBuilder builder = new ProjectTreeBuilder(this.myProject, (JTree)((Object)this.myTree), treeModel, null, (ProjectAbstractTreeStructureBase)this.myTreeStructure){

            @Override
            protected ProjectViewPsiTreeChangeListener createPsiTreeChangeListener(Project project2) {
                return new ProjectTreeBuilder.ProjectTreeBuilderPsiListener(project2){

                    @Override
                    protected void childrenChanged(PsiElement parent, boolean stopProcessingForThisModificationCount) {
                        VirtualFile virtualFile;
                        VirtualFile virtualFile2 = virtualFile = parent instanceof PsiFileSystemItem ? ((PsiFileSystemItem)parent).getVirtualFile() : null;
                        if (virtualFile != null && virtualFile.isValid() && ScratchFileService.getInstance().getRootType(virtualFile) != null) {
                            this.queueUpdateFrom(parent, true);
                        }
                    }
                };
            }
        };
        for (RootType rootId : RootType.getAllRootIds()) {
            if (rootId.isHidden()) continue;
            rootId.registerTreeUpdater(this.myProject, builder);
        }
        return builder;
    }

    @Override
    public SelectInTarget createSelectInTarget() {
        return new ProjectViewSelectInTarget(this.myProject){

            @Override
            protected boolean canSelect(PsiFileSystemItem file2) {
                if (!super.canSelect(file2)) {
                    return false;
                }
                VirtualFile vFile = file2.getVirtualFile();
                if (vFile == null || !vFile.isValid()) {
                    return false;
                }
                return ScratchFileService.getInstance().getRootType(vFile) != null;
            }

            @Override
            protected boolean canWorkWithCustomObjects() {
                return false;
            }

            @Override
            public String toString() {
                return ScratchProjectViewPane.this.getTitle();
            }

            public String getMinorViewId() {
                return ScratchProjectViewPane.this.getId();
            }

            public float getWeight() {
                return ScratchProjectViewPane.this.getWeight();
            }
        };
    }

    @Override
    @Nullable
    protected PsiElement getPSIElement(@Nullable Object element) {
        return element instanceof RootType ? ScratchProjectViewPane.getDirectory(this.myProject, (RootType)element) : super.getPSIElement(element);
    }

    @Nullable
    private static PsiDirectory getDirectory(@NotNull Project project2, @NotNull RootType rootId) {
        String path = ScratchFileService.getInstance().getRootPath(rootId);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        return virtualFile == null ? null : PsiManager.getInstance((Project)project2).findDirectory(virtualFile);
    }

    private static class MyPsiNode
    extends BasePsiNode<PsiFileSystemItem>
    implements NavigatableWithText {
        private final RootType myRootType;

        MyPsiNode(@NotNull Project project2, RootType rootId, @NotNull PsiFileSystemItem value2) {
            super(project2, value2, ViewSettings.DEFAULT);
            this.myRootType = rootId;
        }

        public boolean isAlwaysLeaf() {
            PsiFileSystemItem value2 = (PsiFileSystemItem)this.getValue();
            return value2 != null && !value2.isDirectory();
        }

        @Override
        @Nullable
        protected Collection<AbstractTreeNode> getChildrenImpl() {
            if (this.isAlwaysLeaf()) {
                return Collections.emptyList();
            }
            return (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<AbstractTreeNode>>(){

                public Collection<AbstractTreeNode> compute() {
                    final PsiFileSystemItem value2 = (PsiFileSystemItem)this.getValue();
                    if (value2 == null || !value2.isValid()) {
                        return Collections.emptyList();
                    }
                    final ArrayList list = ContainerUtil.newArrayList();
                    value2.processChildren((PsiElementProcessor)new PsiElementProcessor<PsiFileSystemItem>(){

                        public boolean execute(@NotNull PsiFileSystemItem element) {
                            if (!myRootType.isIgnored(value2.getProject(), element.getVirtualFile())) {
                                list.add(new MyPsiNode(value2.getProject(), myRootType, element));
                            }
                            return true;
                        }
                    });
                    return list;
                }
            });
        }

        @Override
        protected void updateImpl(PresentationData data) {
            VirtualFile virtualFile;
            PsiFileSystemItem value2 = (PsiFileSystemItem)this.getValue();
            VirtualFile virtualFile2 = virtualFile = value2 == null ? null : value2.getVirtualFile();
            if (virtualFile != null && virtualFile.isValid()) {
                data.setIcon(value2.getIcon(0));
                data.setPresentableText((String)ObjectUtils.chooseNotNull((Object)this.myRootType.substituteName(value2.getProject(), virtualFile), (Object)virtualFile.getName()));
            }
        }

        @Nullable
        public String getNavigateActionText(boolean focusEditor) {
            return null;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            PsiFileSystemItem value2 = (PsiFileSystemItem)this.getValue();
            if (!(value2 instanceof PsiDirectory)) {
                return super.contains(file2);
            }
            PsiDirectory dir = (PsiDirectory)value2;
            return VfsUtilCore.isAncestor((VirtualFile)dir.getVirtualFile(), (VirtualFile)file2, (boolean)false) && !FileTypeRegistry.getInstance().isFileIgnored(file2);
        }
    }

    private static class MyRootNode
    extends AbstractTreeNode<RootType> {
        MyRootNode(Project project2, RootType type2) {
            super(project2, (Object)type2);
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            RootType rootType = (RootType)this.getValue();
            PsiDirectory directory = this.getDirectory();
            if (directory == null) {
                return Collections.emptyList();
            }
            return new MyPsiNode(directory.getProject(), rootType, (PsiFileSystemItem)directory).getChildren();
        }

        PsiDirectory getDirectory() {
            return ScratchProjectViewPane.getDirectory(this.getProject(), (RootType)this.getValue());
        }

        protected void update(PresentationData presentation) {
            presentation.setIcon(PlatformIcons.DIRECTORY_CLOSED_ICON);
            presentation.setPresentableText(((RootType)this.getValue()).getDisplayName());
        }
    }

    private static class MyProjectNode
    extends AbstractTreeNode<Project> {
        MyProjectNode(Project project2) {
            super(project2, (Object)project2);
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ArrayList list = ContainerUtil.newArrayList();
            for (RootType rootId : RootType.getAllRootIds()) {
                MyRootNode e;
                if (rootId.isHidden() || (e = new MyRootNode(this.getProject(), rootId)).getDirectory() == null) continue;
                list.add(e);
            }
            return list;
        }

        protected void update(PresentationData presentation) {
        }
    }

    private static class MyTreeStructure
    extends ProjectTreeStructure {
        MyTreeStructure(Project project2) {
            super(project2, ScratchProjectViewPane.ID);
        }

        @Override
        protected AbstractTreeNode createRoot(Project project2, ViewSettings settings) {
            return new MyProjectNode(project2);
        }

        @Override
        @Nullable
        public List<TreeStructureProvider> getProviders() {
            return null;
        }
    }
}

