/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.customRegions;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.customRegions.CustomRegionTreeElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomRegionStructureUtil {
    public static Collection<StructureViewTreeElement> groupByCustomRegions(@NotNull PsiElement rootElement, @NotNull Collection<StructureViewTreeElement> originalElements) {
        if (rootElement instanceof StubBasedPsiElement && ((StubBasedPsiElement)rootElement).getStub() != null) {
            return originalElements;
        }
        Set childrenRanges = ContainerUtil.map2SetNotNull(originalElements, element -> {
            Object value2 = element.getValue();
            return value2 instanceof PsiElement ? CustomRegionStructureUtil.getTextRange((PsiElement)value2) : null;
        });
        Collection<CustomRegionTreeElement> customRegions = CustomRegionStructureUtil.collectCustomRegions(rootElement, childrenRanges);
        if (customRegions.size() > 0) {
            ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>();
            result2.addAll(customRegions);
            for (StructureViewTreeElement element2 : originalElements) {
                boolean isInCustomRegion = false;
                for (CustomRegionTreeElement customRegion : customRegions) {
                    if (!customRegion.containsElement(element2)) continue;
                    customRegion.addChild(element2);
                    isInCustomRegion = true;
                    break;
                }
                if (isInCustomRegion) continue;
                result2.add(element2);
            }
            return result2;
        }
        return originalElements;
    }

    private static TextRange getTextRange(@NotNull PsiElement element) {
        PsiElement first = element.getFirstChild();
        if (first instanceof PsiComment && !first.textContains('\n')) {
            PsiElement next = first.getNextSibling();
            if (next instanceof PsiWhiteSpace) {
                next = next.getNextSibling();
            }
            if (next != null) {
                return new TextRange(next.getTextRange().getStartOffset(), element.getTextRange().getEndOffset());
            }
        }
        return element.getTextRange();
    }

    private static Collection<CustomRegionTreeElement> collectCustomRegions(@NotNull PsiElement rootElement, @NotNull Set<TextRange> ranges) {
        Iterator iterator = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)rootElement).filter(element -> CustomRegionStructureUtil.isCustomRegionCommentCandidate(element) && !CustomRegionStructureUtil.isInsideRanges(element, ranges))).iterator();
        List customRegions = ContainerUtil.newSmartList();
        CustomRegionTreeElement currRegionElement = null;
        CustomFoldingProvider provider2 = null;
        while (iterator.hasNext()) {
            PsiElement child = (PsiElement)iterator.next();
            if (provider2 == null) {
                provider2 = CustomRegionStructureUtil.getProvider(child);
            }
            if (provider2 == null) continue;
            String commentText = child.getText();
            if (provider2.isCustomRegionStart(commentText)) {
                if (currRegionElement == null) {
                    currRegionElement = new CustomRegionTreeElement(child, provider2);
                    customRegions.add(currRegionElement);
                    continue;
                }
                currRegionElement = currRegionElement.createNestedRegion(child);
                continue;
            }
            if (!provider2.isCustomRegionEnd(commentText) || currRegionElement == null) continue;
            currRegionElement = currRegionElement.endRegion(child);
        }
        return customRegions;
    }

    @Nullable
    static CustomFoldingProvider getProvider(@NotNull PsiElement element) {
        ASTNode node = element.getNode();
        if (node != null) {
            for (CustomFoldingProvider provider2 : CustomFoldingProvider.getAllProviders()) {
                if (!provider2.isCustomRegionStart(node.getText())) continue;
                return provider2;
            }
        }
        return null;
    }

    private static boolean isInsideRanges(@NotNull PsiElement element, @NotNull Set<TextRange> ranges) {
        for (TextRange range : ranges) {
            TextRange elementRange;
            if (!range.contains((elementRange = element.getTextRange()).getStartOffset()) && !range.contains(elementRange.getEndOffset())) continue;
            return true;
        }
        return false;
    }

    private static boolean isCustomRegionCommentCandidate(@NotNull PsiElement element) {
        Language language = element.getLanguage();
        if (!Language.ANY.is(language)) {
            FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
            if (foldingBuilder instanceof CustomFoldingBuilder) {
                return ((CustomFoldingBuilder)foldingBuilder).isCustomFoldingCandidate(element);
            }
            if (foldingBuilder instanceof CompositeFoldingBuilder) {
                for (FoldingBuilder simpleBuilder : ((CompositeFoldingBuilder)foldingBuilder).getAllBuilders()) {
                    if (!(simpleBuilder instanceof CustomFoldingBuilder) || !((CustomFoldingBuilder)simpleBuilder).isCustomFoldingCandidate(element)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

