/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.common;

import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.customRegions.CustomRegionStructureUtil;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.navigation.ItemPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiTreeElementBase<T extends PsiElement>
implements StructureViewTreeElement,
ItemPresentation,
NodeDescriptorProvidingKey {
    private final T myValue;

    protected PsiTreeElementBase(T psiElement) {
        this.myValue = psiElement;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return this;
    }

    @NotNull
    public Object getKey() {
        try {
            return this.myValue.toString();
        }
        catch (Exception e) {
            return this.myValue.getClass();
        }
    }

    @Nullable
    public final T getElement() {
        return this.myValue.isValid() ? (T)this.myValue : null;
    }

    public Icon getIcon(boolean open2) {
        T element = this.getElement();
        if (element != null) {
            int flags = 2;
            if (!(element instanceof PsiFile) || !element.isWritable()) {
                flags |= 1;
            }
            return element.getIcon(flags);
        }
        return null;
    }

    public T getValue() {
        return this.getElement();
    }

    public String getLocationString() {
        return null;
    }

    public boolean isSearchInLocationString() {
        return false;
    }

    public String toString() {
        T element = this.getElement();
        return element != null ? element.toString() : "";
    }

    @NotNull
    public final StructureViewTreeElement[] getChildren() {
        T element = this.getElement();
        if (element == null) {
            return EMPTY_ARRAY;
        }
        ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>();
        Collection<StructureViewTreeElement> baseChildren = this.getChildrenBase();
        result2.addAll(CustomRegionStructureUtil.groupByCustomRegions(element, baseChildren));
        StructureViewFactoryEx structureViewFactory = StructureViewFactoryEx.getInstanceEx(element.getProject());
        Class<?> aClass = element.getClass();
        for (StructureViewExtension extension : structureViewFactory.getAllExtensions(aClass)) {
            Object[] children2 = extension.getChildren((PsiElement)element);
            if (children2 == null) continue;
            ContainerUtil.addAll(result2, (Object[])children2);
        }
        return result2.toArray(new StructureViewTreeElement[result2.size()]);
    }

    public void navigate(boolean requestFocus) {
        T element = this.getElement();
        if (element != null) {
            ((Navigatable)element).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        T element = this.getElement();
        return element instanceof Navigatable && ((Navigatable)element).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public abstract Collection<StructureViewTreeElement> getChildrenBase();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiTreeElementBase that = (PsiTreeElementBase)o;
        T value2 = this.getValue();
        return value2 == null ? that.getValue() == null : value2.equals(that.getValue());
    }

    public int hashCode() {
        T value2 = this.getValue();
        return value2 == null ? 0 : value2.hashCode();
    }

    public boolean isValid() {
        return this.myValue != null && this.myValue.isValid();
    }
}

