/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.impl.java.ClassInitializerTreeElement;
import com.intellij.ide.structureView.impl.java.JavaAnonymousClassTreeElement;
import com.intellij.ide.structureView.impl.java.PsiFieldTreeElement;
import com.intellij.ide.structureView.impl.java.PsiMethodTreeElement;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.AnonymousElementProvider;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.PropertyOwner;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaAnonymousClassesNodeProvider
implements FileStructureNodeProvider<JavaAnonymousClassTreeElement>,
PropertyOwner {
    public static final String ID = "SHOW_ANONYMOUS";
    public static final String JAVA_ANONYMOUS_PROPERTY_NAME = "java.anonymous.provider";

    @NotNull
    public Collection<JavaAnonymousClassTreeElement> provideNodes(@NotNull TreeElement node) {
        Object el;
        if ((node instanceof PsiMethodTreeElement || node instanceof PsiFieldTreeElement || node instanceof ClassInitializerTreeElement) && (el = ((PsiTreeElementBase)node).getElement()) != null) {
            for (AnonymousElementProvider provider2 : (AnonymousElementProvider[])Extensions.getExtensions((ExtensionPointName)AnonymousElementProvider.EP_NAME)) {
                PsiElement[] elements = provider2.getAnonymousElements(el);
                if (elements.length <= 0) continue;
                ArrayList<JavaAnonymousClassTreeElement> result2 = new ArrayList<JavaAnonymousClassTreeElement>(elements.length);
                for (PsiElement element : elements) {
                    result2.add(new JavaAnonymousClassTreeElement((PsiAnonymousClass)element, (Set<PsiClass>)new HashSet()));
                }
                return result2;
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    public String getCheckBoxText() {
        return "Show Anonymous Classes";
    }

    @NotNull
    public Shortcut[] getShortcut() {
        return new Shortcut[]{KeyboardShortcut.fromString((String)(SystemInfo.isMac ? "meta I" : "control I"))};
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(this.getCheckBoxText(), null, PlatformIcons.ANONYMOUS_CLASS_ICON);
    }

    @NotNull
    public String getName() {
        return ID;
    }

    @NotNull
    public String getPropertyName() {
        return JAVA_ANONYMOUS_PROPERTY_NAME;
    }
}

